/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.filters;

import org.eclipse.hyades.logging.adapter.internal.filters.IFilterAtom;
import org.eclipse.hyades.logging.adapter.internal.filters.IFilterType;

public class NumericalFilterType
implements IFilterType {
    public static final String EQUALS = "equals";
    public static final String GREATERTHAN = "greaterThan";
    public static final String LESSTHAN = "lessThan";
    public static final String GREATERTHANOREQUAL = "greaterThanOrEqual";
    public static final String LESSTHANOREQUAL = "lessThanOrEqual";
    private static final String[] operands = new String[]{"greaterThan", "lessThan", "equals", "greaterThanOrEqual", "lessThanOrEqual"};

    public String[] getOperators() {
        return operands;
    }

    public boolean processRule(IFilterAtom rule) {
        int k;
        String[] leftOperands;
        boolean result = rule.isNegated();
        String leftOperand = rule.getLeftOperand();
        if (rule.getOperator().equals(GREATERTHANOREQUAL)) {
            if (leftOperand != null) {
                result = this.greaterThan(leftOperand, rule.getRightOperand()) || this.equals(leftOperand, rule.getRightOperand());
            } else {
                leftOperands = rule.getLeftOperands();
                if (leftOperands != null) {
                    k = 0;
                    while (k < leftOperands.length) {
                        boolean bl = result = this.greaterThan(leftOperands[k], rule.getRightOperand()) || this.equals(leftOperands[k], rule.getRightOperand());
                        if (!rule.isNegated() && result) {
                            return result;
                        }
                        if (rule.isNegated() && !result) {
                            return !result;
                        }
                        ++k;
                    }
                }
            }
        } else if (rule.getOperator().equals(LESSTHANOREQUAL)) {
            if (leftOperand != null) {
                result = this.lessThan(leftOperand, rule.getRightOperand()) || this.equals(leftOperand, rule.getRightOperand());
            } else {
                leftOperands = rule.getLeftOperands();
                if (leftOperands != null) {
                    k = 0;
                    while (k < leftOperands.length) {
                        boolean bl = result = this.lessThan(leftOperands[k], rule.getRightOperand()) || this.equals(leftOperands[k], rule.getRightOperand());
                        if (!rule.isNegated() && result) {
                            return result;
                        }
                        if (rule.isNegated() && !result) {
                            return !result;
                        }
                        ++k;
                    }
                }
            }
        } else if (rule.getOperator().equals(EQUALS)) {
            if (leftOperand != null) {
                result = this.equals(leftOperand, rule.getRightOperand());
            } else {
                leftOperands = rule.getLeftOperands();
                if (leftOperands != null) {
                    k = 0;
                    while (k < leftOperands.length) {
                        result = this.equals(leftOperands[k], rule.getRightOperand());
                        if (!rule.isNegated() && result) {
                            return result;
                        }
                        if (rule.isNegated() && !result) {
                            return !result;
                        }
                        ++k;
                    }
                }
            }
        }
        if (rule.getOperator().equals(GREATERTHAN)) {
            if (leftOperand != null) {
                result = this.greaterThan(leftOperand, rule.getRightOperand());
            } else {
                leftOperands = rule.getLeftOperands();
                if (leftOperands != null) {
                    k = 0;
                    while (k < leftOperands.length) {
                        result = this.greaterThan(leftOperands[k], rule.getRightOperand());
                        if (!rule.isNegated() && result) {
                            return result;
                        }
                        if (rule.isNegated() && !result) {
                            return !result;
                        }
                        ++k;
                    }
                }
            }
        } else if (rule.getOperator().equals(LESSTHAN)) {
            if (leftOperand != null) {
                result = this.lessThan(leftOperand, rule.getRightOperand());
            } else {
                leftOperands = rule.getLeftOperands();
                if (leftOperands != null) {
                    k = 0;
                    while (k < leftOperands.length) {
                        result = this.lessThan(leftOperands[k], rule.getRightOperand());
                        if (!rule.isNegated() && result) {
                            return result;
                        }
                        if (rule.isNegated() && !result) {
                            return !result;
                        }
                        ++k;
                    }
                }
            }
        }
        if (rule.isNegated()) {
            return !result;
        }
        return result;
    }

    protected boolean equals(String lhs, String rhs) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        try {
            int lnum = Integer.parseInt(lhs);
            int rnum = Integer.parseInt(rhs);
            return lnum == rnum;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                float lnum = Float.parseFloat(lhs);
                float rnum = Float.parseFloat(rhs);
                return lnum == rnum;
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    double lnum = Double.parseDouble(lhs);
                    double rnum = Double.parseDouble(rhs);
                    return lnum == rnum;
                }
                catch (NumberFormatException numberFormatException3) {
                    return false;
                }
            }
        }
    }

    protected boolean greaterThan(String lhs, String rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        try {
            int lnum = Integer.parseInt(lhs);
            int rnum = Integer.parseInt(rhs);
            return lnum > rnum;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                float lnum = Float.parseFloat(lhs);
                float rnum = Float.parseFloat(rhs);
                return lnum > rnum;
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    double lnum = Double.parseDouble(lhs);
                    double rnum = Double.parseDouble(rhs);
                    return lnum > rnum;
                }
                catch (NumberFormatException numberFormatException3) {
                    return false;
                }
            }
        }
    }

    protected boolean lessThan(String lhs, String rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        try {
            int lnum = Integer.parseInt(lhs);
            int rnum = Integer.parseInt(rhs);
            return lnum < rnum;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                float lnum = Float.parseFloat(lhs);
                float rnum = Float.parseFloat(rhs);
                return lnum < rnum;
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    double lnum = Double.parseDouble(lhs);
                    double rnum = Double.parseDouble(rhs);
                    return lnum < rnum;
                }
                catch (NumberFormatException numberFormatException3) {
                    return false;
                }
            }
        }
    }
}

