/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.sun50.fastxpath.functions;

import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.ExpressionNode;
import com.sun.org.apache.xpath.internal.XPathVisitor;
import com.sun.org.apache.xpath.internal.functions.FuncExtFunction;
import com.sun.org.apache.xpath.internal.functions.WrongNumberArgsException;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FXPObject;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.IExpression;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerContext;
import org.eclipse.tptp.platform.provisional.fastxpath.utils.StrTools;
import org.eclipse.tptp.platform.provisional.sun50.fastxpath.EExpressionFactory;
import org.eclipse.tptp.platform.provisional.sun50.fastxpath.functions.EFunction;

public class EFuncExtFunction
extends EFunction {
    private FuncExtFunction fef;

    public IExpression instance(Expression expression) {
        return new EFuncExtFunction((FuncExtFunction)expression);
    }

    public EFuncExtFunction(FuncExtFunction funcExtFunction) {
        this.fef = funcExtFunction;
    }

    public void callArgVisitors(XPathVisitor xPathVisitor) {
        this.fef.callArgVisitors(xPathVisitor);
    }

    public void checkNumberArgs(int n) throws WrongNumberArgsException {
        this.fef.checkNumberArgs(n);
    }

    public void exprSetParent(ExpressionNode expressionNode) {
        this.fef.exprSetParent(expressionNode);
    }

    public Expression getArg(int n) {
        return this.fef.getArg(n);
    }

    public int getArgCount() {
        return this.fef.getArgCount();
    }

    public String getFunctionName() {
        return this.fef.getFunctionName();
    }

    public String getNamespace() {
        return this.fef.getNamespace();
    }

    public void setArg(Expression expression, int n) throws WrongNumberArgsException {
        this.fef.setArg(expression, n);
    }

    public void printGraph(int n) {
        super.printGraph(n);
        int n2 = this.getArgCount();
        for (int i = 0; i < n2; ++i) {
            IExpression iExpression = EExpressionFactory.INSTANCE.createEExprNode(this.getArg(i));
            System.out.println(this.indent(n) + "arg:");
            iExpression.printGraph(n + 1);
        }
    }

    public Object[] execute(FastXPathContext fastXPathContext) throws TransformerException, ExpressionEvaluationException {
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = this.getArgCount();
        for (int i = 0; i < n; ++i) {
            IExpression iExpression = EExpressionFactory.INSTANCE.createEExprNode(this.getArg(i));
            Object[] objectArray = iExpression.execute(fastXPathContext);
            for (int j = 0; j < objectArray.length; ++j) {
                while (objectArray[j] instanceof FXPObject) {
                    objectArray[j] = ((FXPObject)objectArray[j]).getVal();
                }
                objectArray[j] = objectArray[j].toString();
            }
            vector.add(objectArray);
        }
        return this.execute(vector, fastXPathContext);
    }

    private Object[] execute(Vector vector, FastXPathContext fastXPathContext) throws TransformerException {
        if (this.fef.getNamespace().equals("StrTools") && this.fef.getFunctionName().equals("strcmp")) {
            return new Object[]{new Integer(StrTools.strcmp((Object[])vector.get(0), (Object[])vector.get(1)))};
        }
        throw new TransformerException(new UnsupportedOperationException("not implemented yet for SUN 1.5"));
    }

    public void compile(ICompilerContext iCompilerContext) throws CodeGenerationError {
        Class clazz = iCompilerContext.getFastXPathEngine().getExtensionFunctionClass(this.getNamespace());
        if (clazz == null) {
            throw new CodeGenerationError(this.getNamespace() + "not yet introduced in FastXPathEngine");
        }
        iCompilerContext.in(this);
        iCompilerContext.append(clazz.getName() + "." + this.fef.getFunctionName() + "(");
        int n = this.getArgCount();
        String string = "";
        for (int i = 0; i < n; ++i) {
            iCompilerContext.append(string);
            iCompilerContext.append("new Object[]{ ");
            IExpression iExpression = EExpressionFactory.INSTANCE.createEExprNode(this.getArg(i));
            iExpression.compile(iCompilerContext);
            iCompilerContext.append("}");
            string = ", ";
        }
        iCompilerContext.append(")");
        iCompilerContext.out();
    }
}

