/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRecordType;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRecordTypes;

public class RecordTypes
implements IRecordTypes {
    private String namespace = null;
    private String schemaLocation = null;
    private List<IRecordType> recordType = new ArrayList<IRecordType>();

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void addRecordType(IRecordType recordType) {
        this.recordType.add(recordType);
    }

    public IRecordType[] getRecordType() {
        return this.recordType.toArray(new IRecordType[this.recordType.size()]);
    }

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write(CMDBfServicesUtil.tagFor((boolean)false, null, (String)"recordTypes", (boolean)false));
        if (this.namespace != null || this.schemaLocation != null) {
            if (this.namespace != null) {
                writer.write(" ");
                CMDBfServicesUtil.writeAttribute((StringWriter)writer, (String)"namespace", (String)this.namespace);
            }
            if (this.schemaLocation != null) {
                writer.write(" ");
                CMDBfServicesUtil.writeAttribute((StringWriter)writer, (String)"schemaLocation", (String)this.schemaLocation);
            }
        }
        writer.write(">" + ICMDBfServicesConstants.nl);
        CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), this.recordType);
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor((String)"recordTypes")) + ICMDBfServicesConstants.nl);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecordTypes other = (RecordTypes)obj;
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        if (this.schemaLocation == null ? other.schemaLocation != null : !this.schemaLocation.equals(other.schemaLocation)) {
            return false;
        }
        return !(this.recordType == null ? other.recordType != null : !this.recordType.equals(other.recordType));
    }
}

