/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.broker.ws;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ServiceContext;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Group;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Groups;
import org.eclipse.cosmos.dc.broker.ws.persistence.BrokerDatabase;
import org.eclipse.cosmos.dc.broker.ws.persistence.internal.BrokerDatabaseImpl;

public class Broker {
    BrokerDatabase database = null;

    public void init(ServiceContext serviceContext) {
        this.database = BrokerDatabaseImpl.getInstance();
        File dbdir = serviceContext.getConfigurationContext().getRealPath("database");
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        initMap.put("dbdir", dbdir);
        this.database.init(initMap);
    }

    public OMElement registerGroup(OMElement registerGroupRequest) {
        System.out.println("In registerGroup");
        System.out.println(registerGroupRequest.toString());
        OMElement groupElem = registerGroupRequest.getFirstElement();
        this.database.addGroup(Group.getGroup(groupElem));
        return null;
    }

    public OMElement deregisterGroup(OMElement deregisterRequest) {
        System.out.println("In deregisterGroup");
        String host = null;
        String groupName = null;
        Iterator childIter = deregisterRequest.getChildElements();
        while (childIter.hasNext()) {
            OMElement elem = (OMElement)childIter.next();
            if (elem.getLocalName().equals("host")) {
                host = elem.getText();
                continue;
            }
            if (!elem.getLocalName().equals("name")) continue;
            groupName = elem.getText();
        }
        if (host != null && groupName != null) {
            this.database.deleteGroup(host, groupName);
        }
        return null;
    }

    public OMElement getAllGroups(OMElement getAllGroupsRequest) {
        System.out.println("In getAllGroups");
        Groups groups = this.database.getAllGroups();
        return groups.toOM();
    }

    public OMElement getGroup(OMElement getGroupRequest) {
        Group group = new Group();
        String host = null;
        String groupName = null;
        Iterator childIter = getGroupRequest.getChildElements();
        while (childIter.hasNext()) {
            OMElement elem = (OMElement)childIter.next();
            if (elem.getLocalName().equals("host")) {
                host = elem.getText();
                continue;
            }
            if (!elem.getLocalName().equals("name")) continue;
            groupName = elem.getText();
        }
        if (host == null || groupName == null) {
            return null;
        }
        group = this.database.getGroup(host, groupName);
        return group == null ? null : group.toOM();
    }

    public OMElement getGroupsByNamespace(OMElement getGroupsByNamespaceRequest) {
        String ns = null;
        Groups groups = new Groups();
        Iterator childIter = getGroupsByNamespaceRequest.getChildElements();
        while (childIter.hasNext()) {
            OMElement elem = (OMElement)childIter.next();
            if (!elem.getLocalName().equals("namespace")) continue;
            ns = elem.getText();
        }
        if (ns != null) {
            groups = this.database.getGroupsByNamespace(ns);
        }
        return groups.toOM();
    }
}

