/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.stat.datamgr.ws.client;

public class StatisticalObservation {
    private boolean isIntegral = false;
    private boolean isContinuous = false;
    private boolean isString = false;
    private boolean isNull = true;
    private long integralValue;
    private String stringValue;
    private double continuousValue;
    private String name;

    public StatisticalObservation(String name, Object observation) {
        this.name = name;
        if (observation != null) {
            this.isNull = false;
            Class<?> observationClass = observation.getClass();
            if (Double.class.isAssignableFrom(observationClass)) {
                this.continuousValue = (Double)observation;
                this.isContinuous = true;
            } else if (Float.class.isAssignableFrom(observationClass)) {
                this.continuousValue = ((Float)observation).floatValue();
                this.isContinuous = true;
            } else if (Integer.class.isAssignableFrom(observationClass)) {
                this.integralValue = ((Integer)observation).intValue();
                this.isIntegral = true;
            } else if (Long.class.isAssignableFrom(observationClass)) {
                this.integralValue = (Long)observation;
                this.isIntegral = true;
            } else {
                this.stringValue = observation.toString();
                this.isString = true;
            }
        }
    }

    public boolean isIntegralObservation() {
        return this.isIntegral;
    }

    public boolean isStringObservation() {
        return this.isString;
    }

    public boolean isContinuousObservation() {
        return this.isContinuous;
    }

    public long getIntegralValue() {
        return this.integralValue;
    }

    public void setIntegralValue(long integralValue) {
        this.integralValue = integralValue;
    }

    public double getContinuousValue() {
        return this.continuousValue;
    }

    public void setContinuousValue(double continuousValue) {
        this.continuousValue = continuousValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        String ret = String.valueOf(this.name) + " = ";
        ret = this.isIntegral ? ret.concat(String.valueOf(this.integralValue)) : (this.isContinuous ? ret.concat(String.valueOf(this.continuousValue)) : ret.concat(this.stringValue));
        return ret;
    }
}

