/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.broker.ws.client;

import java.util.List;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Group;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Service;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Services;
import org.eclipse.cosmos.dc.cmdbf.query.client.QueryServiceClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataManager {
    private Group group;
    private boolean supportsCMDBfQuery = false;
    private String queryServiceEPR = null;
    private boolean supportsCMDBfRegistration = false;
    private String registrationServiceEPR = null;
    private String host;
    private String name;
    private String description;

    public DataManager(Group group) {
        this.group = group;
        this.host = group.getHost();
        this.name = group.getName();
        this.description = group.getDescription();
        Services services = group.getServices();
        if (services != null) {
            List<Service> serviceList = services.getServices();
            for (Service service : serviceList) {
                String ns = service.getNamespace();
                if (ns.equals("http://cmdbf.org/schema/1-0-0/query")) {
                    this.supportsCMDBfQuery = true;
                    this.queryServiceEPR = service.getEndpointReference();
                    continue;
                }
                if (!ns.equals("http://cmdbf.org/schema/1-0-0/registration")) continue;
                this.supportsCMDBfRegistration = true;
                this.registrationServiceEPR = service.getEndpointReference();
            }
        }
    }

    public boolean isSupportsCMDBfQuery() {
        return this.supportsCMDBfQuery;
    }

    public boolean isSupportsCMDBfRegistration() {
        return this.supportsCMDBfRegistration;
    }

    public QueryServiceClient getCMDBfQueryClient() {
        if (this.supportsCMDBfQuery) {
            return new QueryServiceClient(this.queryServiceEPR);
        }
        return null;
    }

    public String getServiceEPR(String namespace) {
        Services services = this.group.getServices();
        List<Service> serviceList = services.getServices();
        for (Service service : serviceList) {
            String ns = service.getNamespace();
            if (!ns.equals(namespace)) continue;
            return service.getEndpointReference();
        }
        return null;
    }

    public List<Service> getServices() {
        if (this.group.getServices() != null) {
            return this.group.getServices().getServices();
        }
        return null;
    }

    public String getHost() {
        return this.host;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

