/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.cosmos.rm.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.core.FileSystemSMLRepository;
import org.eclipse.cosmos.rm.repository.internal.core.MetadataFileHandler;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.repository.resource.ISMLDocument;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataProcessor {
    public static final byte FIELD_NAME = 0;
    public static final byte FIELD_DISPLAY_NAME = 1;
    public static final byte FIELD_VERSION = 2;
    public static final byte FIELD_DESCRIPTION = 3;
    public static final byte FIELD_BASE_URI = 4;
    private FileSystemSMLRepository repository;
    private MetadataFileHandler metadataHandler;

    public MetadataProcessor(FileSystemSMLRepository repository) {
        this.repository = repository;
        this.metadataHandler = new MetadataFileHandler();
        this.load();
    }

    private void load() {
        File metadataFile = new File(String.valueOf(this.repository.getProperty("root.directory", "")) + "/" + ".smlif_meta");
        if (!metadataFile.exists()) {
            return;
        }
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse(metadataFile, (DefaultHandler)this.metadataHandler);
            return;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.metadataHandler = new MetadataFileHandler();
    }

    public List<ISMLDocument> retrieveDocuments(Map<String, Boolean> data, boolean isAlias) {
        Map<String, List<String>> aliasMap = this.metadataHandler.getAliasFileMap();
        Map<String, List<String>> ruleBindings = this.metadataHandler.getRuleAliasBinding();
        ArrayList<String> finalListOfFiles = new ArrayList<String>();
        for (String currentKey : data.keySet()) {
            List<String> listOfData;
            List<String> list = listOfData = isAlias ? aliasMap.get(currentKey) : ruleBindings.get(currentKey);
            if (!isAlias) {
                ArrayList<String> listOfFiles = new ArrayList<String>();
                if (listOfData != null) {
                    int i = 0;
                    int fileCount = listOfData.size();
                    while (i < fileCount) {
                        List<String> o = aliasMap.get(listOfData.get(i));
                        if (o != null) {
                            listOfFiles.addAll(o);
                        }
                        ++i;
                    }
                }
                listOfData = listOfFiles;
            }
            if (listOfData == null) continue;
            finalListOfFiles.addAll(listOfData);
        }
        SMLFileMetadata metadata = new SMLFileMetadata();
        ArrayList<ISMLDocument> listOfSMLDocuments = new ArrayList<ISMLDocument>();
        int i = 0;
        int fileCount = finalListOfFiles.size();
        while (i < fileCount) {
            metadata.setId((String)finalListOfFiles.get(i));
            ISMLDocument[] documents = null;
            try {
                documents = this.repository.fetchDocuments(metadata);
            }
            catch (RepositoryOperationException e) {
                e.printStackTrace();
            }
            if (documents != null) {
                int j = 0;
                while (j < documents.length) {
                    if (!listOfSMLDocuments.contains(documents[j])) {
                        listOfSMLDocuments.add(documents[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return listOfSMLDocuments;
    }

    public String[] retrieveAliases(String id) {
        ArrayList<String> aliases = new ArrayList<String>();
        this.addAliases(aliases, id);
        this.addAliases(aliases, SMLRepositoryUtil.getAlternativeId(this.repository, id));
        return aliases.toArray(new String[aliases.size()]);
    }

    private void addAliases(List<String> aliases, String id) {
        List<String> al = this.metadataHandler.getFileAliasMap().get(id);
        if (al != null) {
            aliases.addAll(al);
        }
    }

    public Map<String, List<String>> retrieveBoundRules(String id) {
        Hashtable<String, List<String>> rules = new Hashtable<String, List<String>>();
        this.copyMap(this.retrieveRules(id), rules);
        this.copyMap(this.retrieveRules(SMLRepositoryUtil.getAlternativeId(this.repository, id)), rules);
        return rules;
    }

    private void copyMap(Map<String, List<String>> source, Map<String, List<String>> destination) {
        Set<String> keys = source.keySet();
        for (String currentKey : keys) {
            List<String> destValue = destination.get(currentKey);
            List<String> srcValue = source.get(currentKey);
            if (destValue == null) {
                destination.put(currentKey, srcValue);
                continue;
            }
            int i = 0;
            int srcValueCount = srcValue.size();
            while (i < srcValueCount) {
                if (!destValue.contains(srcValue.get(i))) {
                    destValue.add(srcValue.get(i));
                }
                ++i;
            }
        }
    }

    private Map<String, List<String>> retrieveRules(String id) {
        String[] aliases = this.retrieveAliases(id);
        Hashtable<String, List<String>> rules = new Hashtable<String, List<String>>();
        if (aliases != null) {
            int i = 0;
            while (i < aliases.length) {
                List<String> ruleAliases = this.metadataHandler.getAliasRuleBinding().get(aliases[i]);
                if (ruleAliases != null) {
                    rules.put(aliases[i], ruleAliases);
                }
                ++i;
            }
        }
        return rules;
    }

    public void addAliases(String id, String[] aliases) {
        this.metadataHandler.addAlias(id, aliases);
    }

    public void addRuleBinding(String alias, String[] rules) {
        this.metadataHandler.addRuleBinding(alias, rules);
    }

    public void setField(byte field, String value) {
        this.metadataHandler.setField(field, value);
    }

    public void setFields(byte[] fields, String[] values) {
        int fieldCount = Math.min(fields.length, values.length);
        int i = 0;
        while (i < fieldCount) {
            this.metadataHandler.setField(fields[i], values[i]);
            ++i;
        }
    }

    public void write() {
        try {
            if (!this.metadataHandler.isDirty()) {
                return;
            }
            File metadataFile = new File(String.valueOf(this.repository.getProperty("root.directory", "")) + "/" + ".smlif_meta");
            if (!metadataFile.exists()) {
                metadataFile.createNewFile();
            }
            PrintStream metadataPrintStream = new PrintStream(metadataFile);
            this.metadataHandler.write(metadataPrintStream);
            metadataPrintStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MetadataFileHandler getMetadataHandler() {
        return this.metadataHandler;
    }

    public Map<String, List<String>> getFileAliasMapping() {
        return this.metadataHandler.getFileAliasMap();
    }

    public Map<String, List<String>> getAliasRuleMapping() {
        return this.metadataHandler.getAliasRuleBinding();
    }
}

