/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations.cmdbf;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IQueryHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.CMDBfQueryOperation;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.QueryOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.rm.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.internal.operations.AbstractSMLOperation;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.SMLConstraintHandlerFactory;
import org.eclipse.cosmos.rm.repository.operations.cmdbf.ICMDBfQueryOperation;

public class SMLQueryOperation
extends AbstractSMLOperation
implements ICMDBfQueryOperation {
    private CMDBfQueryOperation queryOperation = new CMDBfQueryOperation((IQueryHandlerFactory)SMLConstraintHandlerFactory.getInstance(), null);
    private InputStream output;

    public SMLQueryOperation(ISMLRepository repository) {
        super(repository);
        Hashtable<String, ISMLRepository> init = new Hashtable<String, ISMLRepository>();
        init.put("org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.DATA_PROVIDER", repository);
        this.queryOperation.initialize(init);
    }

    public String getId() {
        return "org.eclipse.cosmos.rm.repository.operations.cmdbf.ICMDBfQueryOperation";
    }

    public void run() throws RepositoryOperationException {
        Object[] arguments = this.getArguments();
        if (arguments == null || arguments.length < 1 || !(arguments[0] instanceof InputStream)) {
            throw new RepositoryOperationException("The CMDBf query operation accepts exactly one argument -\nAn InputStream representing the query input string");
        }
        try {
            if (arguments.length >= 2 && arguments[1] instanceof Map) {
                this.queryOperation.setRuntimeOptions((Map)arguments[1]);
            }
            IQueryResult result = this.queryOperation.execute((InputStream)arguments[0]);
            this.output = QueryOutputTransformer.transform((IQueryResult)result);
        }
        catch (CMDBfServiceException e) {
            throw new RepositoryOperationException(e);
        }
    }

    public Object getOutput() {
        return this.output;
    }
}

