/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.cosmos.dc.cmdbf.services.common.IRootElement;
import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.cmdbf.services.transform.ITransformerHandler;
import org.eclipse.cosmos.dc.cmdbf.services.transform.TransformerException;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecordSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMDBfServicesUtil {
    private static String dataModelXsdFileName;
    private static IRecordSerializer recordSerializer;

    public static URI createURI(String uriString) {
        try {
            uriString = uriString.replace(" ", "%20");
            return new URI(uriString);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static String tagNameFor(String namespace, String elementName) {
        StringBuffer buffer = new StringBuffer("");
        if (namespace != null) {
            buffer.append(namespace).append(":");
        }
        buffer.append(elementName);
        return buffer.toString();
    }

    public static void addIndent(StringWriter stringWriter, int indent) {
        int i = 0;
        while (i < indent) {
            stringWriter.append('\t');
            ++i;
        }
    }

    public static String beginTagFor(String elementName) {
        return CMDBfServicesUtil.tagFor(false, null, elementName);
    }

    public static String endTagFor(String elementName) {
        return CMDBfServicesUtil.tagFor(true, null, elementName);
    }

    public static String tagFor(boolean end, String namespace, String elementName) {
        return CMDBfServicesUtil.tagFor(end, namespace, elementName, true);
    }

    public static String tagFor(boolean end, String namespace, String elementName, boolean close) {
        StringBuffer tagBuffer = new StringBuffer();
        tagBuffer.append("<");
        if (end) {
            tagBuffer.append("/");
        }
        tagBuffer.append(CMDBfServicesUtil.tagNameFor(namespace, elementName));
        if (close) {
            tagBuffer.append(">");
        }
        return tagBuffer.toString();
    }

    public static void outputListToXML(StringWriter writer, int indent, List<?> writables) {
        for (IXMLWritable output : writables) {
            output.toXML(writer, indent);
        }
    }

    public static void writeAttribute(StringWriter writer, String attributeName, String attributeValue) {
        writer.write(String.valueOf(attributeName) + "=" + "\"");
        writer.write(attributeValue);
        writer.write("\"");
    }

    public static String beginTagFor(String name, Attributes attributes) {
        String startTag = CMDBfServicesUtil.tagFor(false, null, name, false);
        StringWriter output = new StringWriter();
        output.write(startTag);
        int i = 0;
        while (i < attributes.getLength()) {
            output.write(" ");
            CMDBfServicesUtil.writeAttribute(output, attributes.getQName(i), attributes.getValue(i));
            ++i;
        }
        output.write(">");
        return output.toString();
    }

    public static InputStream getCMDBfDataModel() {
        File schemaFile = new File(CMDBfServicesUtil.getDataModelXsdFileName());
        InputStream inputStream = null;
        if (schemaFile.isAbsolute()) {
            try {
                inputStream = new FileInputStream(schemaFile);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            inputStream = CMDBfServicesUtil.class.getClassLoader().getResourceAsStream(CMDBfServicesUtil.getDataModelXsdFileName());
        }
        return inputStream;
    }

    public static void setDataModelXsdFileName(String dataModelXsdFileName) {
        CMDBfServicesUtil.dataModelXsdFileName = dataModelXsdFileName;
    }

    public static String getDataModelXsdFileName() {
        if (dataModelXsdFileName == null) {
            dataModelXsdFileName = "resources/cmdbfDataModel.xsd";
        }
        return dataModelXsdFileName;
    }

    public static InputStream transformImpl(IXMLWritable writable) {
        StringWriter writer = new StringWriter();
        writable.toXML(writer, 0);
        return new ByteArrayInputStream(writer.getBuffer().toString().getBytes());
    }

    public static IRootElement transformImpl(InputSource inputSource, ITransformerHandler handler) throws TransformerException {
        return CMDBfServicesUtil.transformImpl(inputSource, handler, null);
    }

    public static IRootElement transformImpl(InputSource inputSource, ITransformerHandler handler, Map<String, Object> transformOptions) throws TransformerException {
        boolean validating = true;
        InputStream dataModelStream = null;
        if (transformOptions != null) {
            Object dataModelOption;
            Object validateOption = transformOptions.get("services.transform.validation");
            if (validateOption != null) {
                validating = (Boolean)validateOption;
            }
            if ((dataModelOption = transformOptions.get("services.transform.datamodel")) != null) {
                dataModelStream = (InputStream)dataModelOption;
            }
        }
        if (validating && dataModelStream == null) {
            dataModelStream = CMDBfServicesUtil.getCMDBfDataModel();
            validating = dataModelStream != null;
        }
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setValidating(validating);
            saxParserFactory.setFeature("http://xml.org/sax/features/validation", validating);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser parser = saxParserFactory.newSAXParser();
            if (validating) {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", dataModelStream);
            }
            parser.parse(inputSource, (DefaultHandler)((Object)handler));
        }
        catch (SAXException e) {
            throw new TransformerException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return handler.getResult();
    }

    public static IRecordSerializer getRecordSerializer() {
        return recordSerializer;
    }

    public static void setRecordSerializer(IRecordSerializer recordSerializer) {
        CMDBfServicesUtil.recordSerializer = recordSerializer;
    }

    public static String toString(URI uri) {
        block3: {
            try {
                if (uri != null) break block3;
                return null;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return uri.toString();
            }
        }
        return URLDecoder.decode(uri.toString(), "UTF-8");
    }
}

