/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts;

import java.io.StringWriter;
import java.net.URI;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecordMetadata;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecordSerializer;

public class RecordMetadata
implements IRecordMetadata {
    private URI recordId;
    private String baselineId;
    private String snapshotId;
    private String lastModified;
    private IXMLWritable extensibilityElements;

    public URI getRecordId() {
        return this.recordId;
    }

    public void setRecordId(URI recordId) {
        this.recordId = recordId;
    }

    public String getBaselineId() {
        return this.baselineId;
    }

    public void setBaselineId(String baselineId) {
        this.baselineId = baselineId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public IXMLWritable getExtensibilityElements() {
        return this.extensibilityElements;
    }

    public void setExtensibilityElements(IXMLWritable extensibilityElements) {
        this.extensibilityElements = extensibilityElements;
    }

    public void setExtensibilityElementsFromString(String stringRepresentationOfValue) {
        IRecordSerializer serializer = CMDBfServicesUtil.getRecordSerializer();
        IXMLWritable writable = null;
        writable = serializer != null ? serializer.deserialize(stringRepresentationOfValue) : new CMDBfInternalUtility.XMLWritableString(stringRepresentationOfValue);
        this.setExtensibilityElements(writable);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.baselineId == null ? 0 : this.baselineId.hashCode());
        result = 31 * result + (this.extensibilityElements == null ? 0 : this.extensibilityElements.hashCode());
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.recordId == null ? 0 : this.recordId.hashCode());
        result = 31 * result + (this.snapshotId == null ? 0 : this.snapshotId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecordMetadata other = (RecordMetadata)obj;
        if (this.baselineId == null ? other.baselineId != null : !this.baselineId.equals(other.baselineId)) {
            return false;
        }
        if (this.extensibilityElements == null ? other.extensibilityElements != null : !this.extensibilityElements.equals(other.extensibilityElements)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        if (this.recordId == null ? other.recordId != null : !this.recordId.equals(other.recordId)) {
            return false;
        }
        return !(this.snapshotId == null ? other.snapshotId != null : !this.snapshotId.equals(other.snapshotId));
    }

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent(writer, indent);
        writer.write(String.valueOf(CMDBfServicesUtil.beginTagFor("cmdbf:recordMetadata")) + ICMDBfServicesConstants.nl);
        CMDBfServicesUtil.addIndent(writer, indent + 1);
        writer.write(CMDBfServicesUtil.beginTagFor("cmdbf:recordId"));
        writer.write(CMDBfServicesUtil.toString(this.getRecordId()));
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor("cmdbf:recordId")) + ICMDBfServicesConstants.nl);
        if (this.lastModified != null) {
            CMDBfServicesUtil.addIndent(writer, indent + 1);
            writer.write(CMDBfServicesUtil.beginTagFor("cmdbf:lastModified"));
            writer.write(this.getLastModified().toString());
            writer.write(String.valueOf(CMDBfServicesUtil.endTagFor("cmdbf:lastModified")) + ICMDBfServicesConstants.nl);
        }
        if (this.baselineId != null) {
            CMDBfServicesUtil.addIndent(writer, indent + 1);
            writer.write(CMDBfServicesUtil.beginTagFor("cmdbf:baselineId"));
            writer.write(this.getBaselineId().toString());
            writer.write(String.valueOf(CMDBfServicesUtil.endTagFor("cmdbf:baselineId")) + ICMDBfServicesConstants.nl);
        }
        if (this.snapshotId != null) {
            CMDBfServicesUtil.addIndent(writer, indent + 1);
            writer.write(CMDBfServicesUtil.beginTagFor("cmdbf:snapshotId"));
            writer.write(this.getSnapshotId().toString());
            writer.write(String.valueOf(CMDBfServicesUtil.endTagFor("cmdbf:snapshotId")) + ICMDBfServicesConstants.nl);
        }
        if (this.extensibilityElements != null) {
            this.extensibilityElements.toXML(writer, indent + 1);
        }
        CMDBfServicesUtil.addIndent(writer, indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor("cmdbf:recordMetadata")) + ICMDBfServicesConstants.nl);
    }
}

