/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.query.transform;

import java.io.StringWriter;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.common.IRootElement;
import org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.CommonArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.ITransformerHandler;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IAdditionalRecordType;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecordMetadata;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class QueryOutputStreamHandler
extends DefaultHandler
implements ITransformerHandler {
    private IQueryResult queryResult;
    private IGraphElement currentResultEntity;
    private String currentElementData;
    private INodes currentNodes;
    private IEdges currentEdges;
    private IRecord currentRecord;
    private IInstanceId currentInstanceId;
    private IRecordMetadata currentRecordMetadata;
    private IQueryOutputArtifactFactory artifactFactory;

    public QueryOutputStreamHandler(IQueryOutputArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("http://cmdbf.org/schema/1-0-0/datamodel".equals(uri)) {
            if ("queryResult".equals(localName)) {
                this.queryResult = this.getArtifactFactory().createQueryResult();
            } else if ("item".equals(localName)) {
                this.currentResultEntity = this.getArtifactFactory().createItem();
                this.currentNodes.addItem((IItem)this.currentResultEntity);
            } else if ("relationship".equals(localName)) {
                this.currentResultEntity = this.getArtifactFactory().createRelationship();
                this.currentEdges.addRelationship((IRelationship)this.currentResultEntity);
            } else if ("source".equals(localName)) {
                this.currentInstanceId = CommonArtifactFactory.getInstance().createInstanceId();
            } else if ("target".equals(localName)) {
                this.currentInstanceId = CommonArtifactFactory.getInstance().createInstanceId();
            } else if ("nodes".equals(localName)) {
                String templateId = attributes.getValue("templateId");
                this.currentNodes = this.getArtifactFactory().createNodes(templateId);
                this.queryResult.addNodes(this.currentNodes);
            } else if ("edges".equals(localName)) {
                String templateId = attributes.getValue("templateId");
                this.currentEdges = this.getArtifactFactory().createEdges(templateId);
                this.queryResult.addEdges(this.currentEdges);
            } else if ("record".equals(localName)) {
                this.currentRecord = CommonArtifactFactory.getInstance().createRecord(this.currentResultEntity, null);
                this.currentResultEntity.addRecord(this.currentRecord);
                this.currentElementData = "";
                int i = 0;
                int attCount = attributes.getLength();
                while (i < attCount) {
                    String[] splitQName;
                    String attributeName = attributes.getQName(i);
                    if (attributeName != null && (splitQName = attributeName.split(":")).length > 0 && splitQName[0].equals("xmlns") && attributes.getValue(i) != null) {
                        String prefix = splitQName.length > 1 ? splitQName[1] : "";
                        this.currentRecord.addNamespace(prefix, attributes.getValue(i));
                    }
                    ++i;
                }
            } else if ("instanceId".equals(localName)) {
                this.currentInstanceId = CommonArtifactFactory.getInstance().createInstanceId();
            } else if ("additionalRecordType".equals(localName)) {
                String namespace = attributes.getValue("namespace");
                String locName = attributes.getValue("localName");
                IAdditionalRecordType adt = CommonArtifactFactory.getInstance().createAdditionalRecordType(namespace, locName);
                this.currentResultEntity.addAdditionalRecordType(adt);
            } else if (this.currentRecord != null && "recordMetadata".equals(localName)) {
                this.currentRecord.setValueFromString(this.currentElementData.trim());
                this.currentRecordMetadata = CommonArtifactFactory.getInstance().createRecordMetadata();
                this.currentRecord.setRecordMetadata(this.currentRecordMetadata);
                this.currentElementData = null;
            }
        } else if (this.currentRecord != null && this.currentRecordMetadata == null) {
            StringWriter tempWriter = new StringWriter();
            CMDBfServicesUtil.addIndent((StringWriter)tempWriter, (int)4);
            tempWriter.write(CMDBfServicesUtil.beginTagFor((String)name, (Attributes)attributes));
            tempWriter.write(ICMDBfServicesConstants.nl);
            this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
            if (!name.equals(localName)) {
                String prefix = name.split(":")[0];
                this.currentRecord.addNamespace(prefix, uri);
            }
        }
    }

    protected IQueryOutputArtifactFactory getArtifactFactory() {
        if (this.artifactFactory == null) {
            this.artifactFactory = QueryOutputArtifactFactory.getInstance();
        }
        return this.artifactFactory;
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("http://cmdbf.org/schema/1-0-0/datamodel".equals(uri)) {
            if ("mdrId".equals(localName)) {
                this.currentInstanceId.setMdrId(this.currentElementData.trim());
                this.currentElementData = null;
            } else if ("localId".equals(localName)) {
                this.currentInstanceId.setLocalId(this.currentElementData.trim());
                this.currentElementData = null;
            } else if ("instanceId".equals(localName)) {
                this.currentResultEntity.addInstanceId(this.currentInstanceId);
                this.currentInstanceId = null;
            } else if ("source".equals(localName)) {
                ((IRelationship)this.currentResultEntity).setSourceId(this.currentInstanceId);
                this.currentInstanceId = null;
            } else if ("target".equals(localName)) {
                ((IRelationship)this.currentResultEntity).setTargetId(this.currentInstanceId);
                this.currentInstanceId = null;
            } else if ("record".equals(localName)) {
                this.currentRecord = null;
            } else if ("recordMetadata".equals(localName)) {
                this.currentRecordMetadata = null;
            } else if (this.currentRecordMetadata != null && "recordId".equals(localName)) {
                this.currentRecordMetadata.setRecordId(CMDBfServicesUtil.createURI((String)this.currentElementData.trim()));
                this.currentElementData = null;
            } else if (this.currentRecordMetadata != null && "lastModified".equals(localName)) {
                this.currentRecordMetadata.setLastModified(this.currentElementData.trim());
                this.currentElementData = null;
            } else if (this.currentRecordMetadata != null && "baselineId".equals(localName)) {
                this.currentRecordMetadata.setBaselineId(this.currentElementData.trim());
                this.currentElementData = null;
            } else if (this.currentRecordMetadata != null && "snapshotId".equals(localName)) {
                this.currentRecordMetadata.setSnapshotId(this.currentElementData.trim());
                this.currentElementData = null;
            }
        } else if (this.currentRecord != null && this.currentRecordMetadata == null) {
            StringWriter tempWriter = new StringWriter();
            CMDBfServicesUtil.addIndent((StringWriter)tempWriter, (int)4);
            tempWriter.write(CMDBfServicesUtil.endTagFor((String)name));
            tempWriter.write(ICMDBfServicesConstants.nl);
            this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tempData = new String(ch, start, length).trim();
        if (this.currentElementData == null) {
            this.currentElementData = tempData;
        } else {
            StringWriter tempWriter = new StringWriter();
            if (this.currentRecord != null) {
                CMDBfServicesUtil.addIndent((StringWriter)tempWriter, (int)4);
            }
            tempWriter.write(tempData);
            if (this.currentRecord != null) {
                tempWriter.write(10);
            }
            this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
        }
    }

    public IQueryResult getQueryResult() {
        return this.queryResult;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public IRootElement getResult() {
        return this.getQueryResult();
    }
}

