/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMElement;
import org.eclipse.cosmos.dc.broker.ws.client.BrokerClient;
import org.eclipse.cosmos.dc.broker.ws.client.DataManager;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Group;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Service;
import org.eclipse.cosmos.dc.cmdbf.query.client.QueryServiceClient;
import org.eclipse.cosmos.dc.service.finder.client.CosmosServiceFinderClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CosmosCLI {
    public static String DEFAULT_BROKER_EPR = "http://localhost:8080/axis2/services/Broker";
    private String _serviceFinderEPR = "http://localhost:8080/axis2/services/CosmosServiceFinder";
    private String _brokerEPR = null;
    private String _serviceNamespace = null;

    public static void main(String[] args) throws Exception {
        String brokerEPR = DEFAULT_BROKER_EPR;
        if (args.length != 0) {
            brokerEPR = args[0];
        }
        CosmosCLI clnt = new CosmosCLI(brokerEPR);
        clnt.getInput();
    }

    public CosmosCLI(String epr) {
        this._brokerEPR = new String(epr);
    }

    public void getInput() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        this.printusage();
        block4: while (true) {
            try {
                while (true) {
                    System.out.print("COSMOS> ");
                    String line = br.readLine();
                    if (line.trim().equals("")) continue;
                    if (line.equals("exit")) break block4;
                    try {
                        this.handleCommand(line);
                        continue block4;
                    }
                    catch (Exception e) {
                        System.out.println("Command error: " + e.getMessage());
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                System.exit(1);
                break;
            }
        }
    }

    private void getAllDataManagers() throws Exception {
        BrokerClient brokerclient = new BrokerClient(this._brokerEPR);
        this.processListAllDataManagers(brokerclient);
    }

    private void findDataManagers() throws Exception {
        Iterator<?> iter = this.doFindDataManagers();
        while (iter.hasNext()) {
            OMElement groupElem = (OMElement)iter.next();
            Group group = Group.getGroup((OMElement)groupElem);
            DataManager dm = new DataManager(group);
            this.PrintDM(dm);
        }
    }

    private void registerAll() throws Exception {
        Iterator<?> iter = this.doFindDataManagers();
        this.DoRegister(iter);
    }

    private void deRegister(String host, String name) throws Exception {
        BrokerClient brokerclient = new BrokerClient(this._brokerEPR);
        brokerclient.deregisterGroup(host, name);
    }

    private void handleCommand(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line);
        if (st.hasMoreTokens()) {
            String command = st.nextToken();
            if (command.equalsIgnoreCase("broker")) {
                this.brokerCommands(st);
            } else if (command.equalsIgnoreCase("finddatamanagers")) {
                this.DoFind(st);
            } else if (command.equalsIgnoreCase("graphQuery")) {
                this.runGraphQuery(st);
            } else {
                this.printusage();
            }
        }
    }

    private void brokerCommands(StringTokenizer st) throws Exception {
        String cmd = null;
        if (!st.hasMoreTokens()) {
            System.out.println("missing command argument.");
            return;
        }
        cmd = st.nextToken();
        if (cmd.equals("getDataManagers")) {
            this.doGetDataManagers(st);
        } else if (cmd.equals("registerAllDataManagers")) {
            this.doRegisterAllDataManagers(st);
        } else if (cmd.equals("deregister")) {
            this.doDeregister(st);
        } else {
            System.out.println("Invalid broker command.");
        }
    }

    private void doGetDataManagers(StringTokenizer st) throws Exception {
        String sns = null;
        if (st.hasMoreTokens()) {
            sns = st.nextToken();
            this._serviceNamespace = new String(sns);
        }
        this.getAllDataManagers();
    }

    private void doRegisterAllDataManagers(StringTokenizer st) throws Exception {
        String sfe = null;
        if (st.hasMoreTokens()) {
            sfe = st.nextToken();
            this._serviceFinderEPR = new String(sfe);
        }
        this.registerAll();
    }

    private void doDeregister(StringTokenizer st) throws Exception {
        String h = null;
        String n = null;
        if (!st.hasMoreTokens()) {
            System.out.println("Missing host!");
            return;
        }
        h = st.nextToken();
        if (!st.hasMoreTokens()) {
            System.out.println("Missing name!");
            return;
        }
        n = st.nextToken();
        this.deRegister(h, n);
        System.out.println("DataManager deregistered.");
    }

    private void runGraphQuery(StringTokenizer st) throws Exception {
        String host = null;
        String mdrName = null;
        String queryFilename = null;
        if (!st.hasMoreTokens()) {
            System.out.println("Missing <host>");
            return;
        }
        host = st.nextToken();
        if (!st.hasMoreTokens()) {
            System.out.println("Missing <MDR name>");
            return;
        }
        mdrName = st.nextToken();
        if (!st.hasMoreTokens()) {
            System.out.println("Missing <query filename>");
            return;
        }
        queryFilename = st.nextToken();
        BrokerClient brokerclient = new BrokerClient(this._brokerEPR);
        DataManager dm = brokerclient.getDataManager(host, mdrName);
        if (dm != null) {
            QueryServiceClient queryServiceClient = dm.getCMDBfQueryClient();
            if (queryServiceClient == null) {
                System.out.println(mdrName + " doesn't support queryServiceClient");
            } else {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(queryFilename));
                Element response = queryServiceClient.graphQuery(doc.getDocumentElement());
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer trans = tf.newTransformer();
                StringWriter sw = new StringWriter();
                trans.transform(new DOMSource(response), new StreamResult(sw));
                System.out.println("Query response:");
                System.out.println(sw.toString());
            }
        } else {
            System.out.println(mdrName + " is not registered at the broker. ");
        }
    }

    private void DoFind(StringTokenizer st) throws Exception {
        String epr = null;
        if (!st.hasMoreTokens()) {
            System.out.println("Missing service finder EPR!");
            return;
        }
        epr = st.nextToken();
        this._serviceFinderEPR = new String(epr);
        this.findDataManagers();
    }

    private void printusage() {
        System.out.println("Commands: \nbroker getDataManagers [service namespace] \nbroker registerAllDataManagers [service finder EPR]\nbroker deregister <host> <name>\nfinddatamanagers <service finder EPR>\ngraphQuery <host> <MDR name> <query filename>\nexit");
    }

    private Iterator<?> doFindDataManagers() throws Exception {
        CosmosServiceFinderClient client = new CosmosServiceFinderClient(this._serviceFinderEPR);
        OMElement dataManagers = client.getDataManagers();
        Iterator iter = dataManagers.getChildElements();
        return iter;
    }

    private void DoRegister(Iterator<?> iter) throws Exception {
        BrokerClient brokerclient = new BrokerClient(this._brokerEPR);
        while (iter.hasNext()) {
            OMElement groupElem = (OMElement)iter.next();
            Group group = Group.getGroup((OMElement)groupElem);
            brokerclient.registerGroup(group);
        }
        System.out.println("DataManagers registered");
    }

    private void processListAllDataManagers(BrokerClient brokerclient) throws Exception {
        System.out.println("List all data managers registered at the broker.");
        List dmlist = null;
        dmlist = this._serviceNamespace == null ? brokerclient.getDataManagers() : brokerclient.getDataManagerByNamespace(this._serviceNamespace);
        for (DataManager dm : dmlist) {
            this.PrintDM(dm);
        }
    }

    private void PrintDM(DataManager dm) {
        System.out.println("host: " + dm.getHost());
        System.out.println("name: " + dm.getName());
        System.out.println("Services: ");
        List serviceList = dm.getServices();
        if (serviceList != null) {
            for (Service service : serviceList) {
                System.out.println(" Service: " + service.getName());
                System.out.println("   namespace: " + service.getNamespace());
                System.out.println("   EPR: " + service.getEndpointReference());
                System.out.println();
            }
        }
    }
}

