/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform;

import java.util.Collection;
import java.util.Iterator;
import org.apache.muse.core.Environment;
import org.apache.muse.core.descriptor.DeploymentDescriptor;
import org.apache.muse.core.descriptor.RouterDefinition;
import org.apache.muse.core.descriptor.SerializerDefinition;
import org.apache.muse.core.descriptor.SimpleDeploymentDescriptor;
import org.apache.muse.core.platform.IsolationLayer;
import org.apache.muse.core.routing.ResourceRouter;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.addressing.soap.SoapUtils;
import org.w3c.dom.Document;

public abstract class AbstractIsolationLayer
implements IsolationLayer {
    private static boolean _hasBeenInitialized = false;
    private static boolean _hasFailedToInitialize = false;
    private static SoapFault _causeOfFailure = null;
    private static boolean _isInitializing = false;
    private static boolean _hasBeenShutdown = false;
    private static ResourceRouter _router = null;

    protected DeploymentDescriptor createDeploymentDescriptor() {
        return new SimpleDeploymentDescriptor();
    }

    protected abstract Environment createEnvironment();

    public ResourceRouter getRouter() {
        return _router;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (this.hasBeenInitialized()) {
            return;
        }
        if (_isInitializing) {
            return;
        }
        _isInitializing = true;
        try {
            Environment env = this.createEnvironment();
            DeploymentDescriptor dd = this.createDeploymentDescriptor();
            Document ddXML = env.getDocument("muse.xml");
            dd.load(ddXML, env);
            Collection serializerDefinitions = dd.getSerializerDefinitions();
            Iterator i = serializerDefinitions.iterator();
            SerializerRegistry registry = SerializerRegistry.getInstance();
            while (i.hasNext()) {
                SerializerDefinition next = (SerializerDefinition)i.next();
                Serializer ser = next.create();
                Class type = ser.getSerializableType();
                registry.registerSerializer(type, ser);
            }
            RouterDefinition routerDefinition = dd.getRouterDefinition();
            _router = routerDefinition.newInstance();
            _router.initialize();
            _hasBeenInitialized = true;
        }
        catch (Throwable fault) {
            _hasFailedToInitialize = true;
            _causeOfFailure = SoapUtils.convertToFault(fault);
            fault.printStackTrace();
        }
        finally {
            _isInitializing = false;
        }
    }

    public boolean hasBeenInitialized() {
        return _hasBeenInitialized;
    }

    public boolean hasBeenShutdown() {
        return _hasBeenShutdown;
    }

    public boolean hasFailedToInitialize() {
        return _hasFailedToInitialize;
    }

    public SoapFault getCauseOfFailure() {
        return _causeOfFailure;
    }

    public void shutdown() throws SoapFault {
        _router.shutdown();
        _router = null;
        _hasBeenShutdown = true;
    }
}

