/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.common;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.common.IItemNotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.common.INotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.common.INotificationHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.common.IRelationshipNotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfMessages;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractNotificationHandlerFactory
implements INotificationHandlerFactory {
    private static final int ITEM = 0;
    private static final int RELATIONSHIP = 1;
    private Map<Integer, Map<Integer, INotificationHandler>> cachedHandlers = new Hashtable<Integer, Map<Integer, INotificationHandler>>();

    public IItemNotificationHandler createItemHandler(int type) throws CMDBfServiceException {
        return (IItemNotificationHandler)this.createNotificationHandler(0, type);
    }

    public IRelationshipNotificationHandler createRelationshipHandler(int type) throws CMDBfServiceException {
        return (IRelationshipNotificationHandler)this.createNotificationHandler(1, type);
    }

    private INotificationHandler createNotificationHandler(int entityType, int notificationType) throws CMDBfServiceException {
        if (this.isCachingSupported()) {
            INotificationHandler handler;
            Map<Integer, INotificationHandler> nestedMap = this.cachedHandlers.get(entityType);
            INotificationHandler iNotificationHandler = handler = nestedMap == null ? null : nestedMap.get(notificationType);
            if (handler != null) {
                return handler;
            }
        }
        INotificationHandler handler = null;
        block0 : switch (entityType) {
            case 0: {
                switch (notificationType) {
                    case 0: {
                        handler = this.createRegistrationItemHandler();
                        break;
                    }
                    case 1: {
                        handler = this.createDeregistrationItemHandler();
                    }
                }
                break;
            }
            case 1: {
                switch (notificationType) {
                    case 0: {
                        handler = this.createRegistrationRelationshipHandler();
                        break block0;
                    }
                    case 1: {
                        handler = this.createDeregistrationRelationshipHandler();
                    }
                }
            }
        }
        if (handler != null && this.isCachingSupported()) {
            Map<Integer, INotificationHandler> nestedMap = this.cachedHandlers.get(entityType);
            if (nestedMap == null) {
                nestedMap = new Hashtable<Integer, INotificationHandler>();
                this.cachedHandlers.put(entityType, nestedMap);
            }
            nestedMap.put(notificationType, handler);
        }
        return handler;
    }

    protected IItemNotificationHandler createRegistrationItemHandler() throws CMDBfServiceException {
        throw new CMDBfServiceException(0, 9, NLS.bind((String)CMDBfMessages.unsupportedHandler, (Object[])new String[]{CMDBfMessages.serviceRegistration, CMDBfMessages.item}));
    }

    protected IRelationshipNotificationHandler createRegistrationRelationshipHandler() throws CMDBfServiceException {
        throw new CMDBfServiceException(0, 9, NLS.bind((String)CMDBfMessages.unsupportedHandler, (Object[])new String[]{CMDBfMessages.serviceRegistration, CMDBfMessages.relationship}));
    }

    protected IItemNotificationHandler createDeregistrationItemHandler() throws CMDBfServiceException {
        throw new CMDBfServiceException(0, 9, NLS.bind((String)CMDBfMessages.unsupportedHandler, (Object[])new String[]{CMDBfMessages.serviceDeregistration, CMDBfMessages.item}));
    }

    protected IRelationshipNotificationHandler createDeregistrationRelationshipHandler() throws CMDBfServiceException {
        throw new CMDBfServiceException(0, 9, NLS.bind((String)CMDBfMessages.unsupportedHandler, (Object[])new String[]{CMDBfMessages.serviceDeregistration, CMDBfMessages.relationship}));
    }

    protected boolean isCachingSupported() {
        return true;
    }
}

