/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts;

import java.io.StringWriter;
import java.net.URI;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;

public abstract class AbstractInstanceId
implements IInstanceId {
    private URI mdrId;
    private URI localId;

    public AbstractInstanceId() {
    }

    public AbstractInstanceId(URI mdrId, URI localId) {
        this.setMdrId(mdrId);
        this.setLocalId(localId);
    }

    public AbstractInstanceId(String mdrId, String localId) {
        this.setMdrId(mdrId);
        this.setLocalId(localId);
    }

    public void setLocalId(String localId) {
        this.setLocalId(CMDBfServicesUtil.createURI(localId));
    }

    public void setMdrId(String mdrId) {
        this.setMdrId(CMDBfServicesUtil.createURI(mdrId));
    }

    public URI getMdrId() {
        return this.mdrId;
    }

    public void setMdrId(URI mdrId) {
        this.mdrId = mdrId;
    }

    public URI getLocalId() {
        return this.localId;
    }

    public void setLocalId(URI localId) {
        this.localId = localId;
    }

    public void outputIdentifiers(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent(writer, indent);
        writer.write(CMDBfServicesUtil.beginTagFor("cmdbf:mdrId"));
        writer.write(CMDBfServicesUtil.toString(this.getMdrId()));
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor("cmdbf:mdrId")) + ICMDBfServicesConstants.nl);
        CMDBfServicesUtil.addIndent(writer, indent);
        writer.write(CMDBfServicesUtil.beginTagFor("cmdbf:localId"));
        writer.write(CMDBfServicesUtil.toString(this.getLocalId()));
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor("cmdbf:localId")) + ICMDBfServicesConstants.nl);
    }

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent(writer, indent);
        writer.write(String.valueOf(CMDBfServicesUtil.beginTagFor("cmdbf:" + this.getElementName())) + ICMDBfServicesConstants.nl);
        this.outputIdentifiers(writer, indent + 1);
        CMDBfServicesUtil.addIndent(writer, indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor("cmdbf:" + this.getElementName())) + ICMDBfServicesConstants.nl);
    }

    protected abstract String getElementName();

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.localId == null ? 0 : this.localId.hashCode());
        result = 31 * result + (this.mdrId == null ? 0 : this.mdrId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractInstanceId other = (AbstractInstanceId)obj;
        if (this.localId == null ? other.localId != null : !this.localId.equals(other.localId)) {
            return false;
        }
        return !(this.mdrId == null ? other.mdrId != null : !this.mdrId.equals(other.mdrId));
    }
}

