/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IAdditionalRecordType;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphElement
implements IGraphElement,
IXMLWritable {
    private List<IRecord> records = new ArrayList<IRecord>();
    private List<IInstanceId> instanceIds = new ArrayList<IInstanceId>();
    private List<IAdditionalRecordType> additionalRecordTypes = new ArrayList<IAdditionalRecordType>();

    protected abstract String getElementName();

    protected void outputAdditionalSubelements(StringWriter writer, int i) {
    }

    @Override
    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent(writer, indent);
        writer.write(String.valueOf(CMDBfServicesUtil.beginTagFor("cmdbf:" + this.getElementName())) + ICMDBfServicesConstants.nl);
        this.outputAdditionalSubelements(writer, indent + 1);
        CMDBfServicesUtil.outputListToXML(writer, indent + 1, this.primGetRecords());
        CMDBfServicesUtil.outputListToXML(writer, indent + 1, this.primGetInstanceIds());
        CMDBfServicesUtil.outputListToXML(writer, indent + 1, this.primGetAdditionalRecordTypes());
        CMDBfServicesUtil.addIndent(writer, indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor("cmdbf:" + this.getElementName())) + ICMDBfServicesConstants.nl);
    }

    @Override
    public IRecord[] getRecords() {
        return this.primGetRecords().toArray(new IRecord[this.records.size()]);
    }

    @Override
    public void setRecords(IRecord[] records) {
        this.records.clear();
        int i = 0;
        while (i < records.length) {
            this.addRecord(records[i]);
            ++i;
        }
    }

    private List<IRecord> primGetRecords() {
        return this.records;
    }

    @Override
    public IInstanceId[] getInstanceIds() {
        return this.instanceIds.toArray(new IInstanceId[this.instanceIds.size()]);
    }

    @Override
    public IAdditionalRecordType[] getAdditionalRecordTypes() {
        return this.additionalRecordTypes.toArray(new IAdditionalRecordType[this.additionalRecordTypes.size()]);
    }

    @Override
    public void addRecord(IRecord record) {
        this.primGetRecords().add(record);
    }

    @Override
    public void removeRecord(IRecord record) {
        this.primGetRecords().remove(record);
    }

    @Override
    public void addAdditionalRecordType(IAdditionalRecordType additionalRecordType) {
        this.primGetAdditionalRecordTypes().add(additionalRecordType);
    }

    private List<IAdditionalRecordType> primGetAdditionalRecordTypes() {
        return this.additionalRecordTypes;
    }

    @Override
    public void addInstanceId(IInstanceId instanceId) {
        this.primGetInstanceIds().add(instanceId);
    }

    private List<IInstanceId> primGetInstanceIds() {
        return this.instanceIds;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.additionalRecordTypes == null ? 0 : this.additionalRecordTypes.hashCode());
        result = 31 * result + (this.instanceIds == null ? 0 : this.instanceIds.hashCode());
        result = 31 * result + (this.records == null ? 0 : this.records.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphElement other = (GraphElement)obj;
        if (this.additionalRecordTypes == null ? other.additionalRecordTypes != null : !this.additionalRecordTypes.equals(other.additionalRecordTypes)) {
            return false;
        }
        if (this.instanceIds == null ? other.instanceIds != null : !this.instanceIds.equals(other.instanceIds)) {
            return false;
        }
        return !(this.records == null ? other.records != null : !this.records.equals(other.records));
    }
}

