/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.reference;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.reference.BadExpressionException;
import org.eclipse.cosmos.rm.validation.internal.reference.IXScheme;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScheme
implements IXScheme {
    private static XPath xpath;
    private String expression;
    private NamespaceContext namespaceContext;

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public Object evaluate(Object context) throws BadExpressionException {
        if (xpath == null) {
            XPathFactory factory = XPathFactory.newInstance();
            if (factory == null) {
                throw new BadExpressionException(SMLValidationMessages.errorMissingXPathFactory);
            }
            xpath = factory.newXPath();
            if (xpath == null) {
                throw new BadExpressionException(SMLValidationMessages.errorMissingXPathInstance);
            }
        }
        if (this.getNamespaceContext() != null) {
            xpath.setNamespaceContext(this.getNamespaceContext());
        }
        ArrayList<NodeList> listOfNodeList = new ArrayList<NodeList>();
        try {
            XPathExpression xpathExpr;
            String xpathExpStr = this.getExpression();
            if (xpathExpStr != null) {
                xpathExpStr = xpathExpStr.replace('\ufffd', '\'');
            }
            if ((xpathExpr = xpath.compile(xpathExpStr)) == null) {
                throw new BadExpressionException(SMLValidationMessages.errorBadXPathExpression);
            }
            if (context instanceof Node) {
                this.evaluateXPathExpression(xpathExpr, (Node)context, listOfNodeList);
            } else if (context instanceof NodeList[]) {
                NodeList[] contextNodeList = (NodeList[])context;
                int i = 0;
                while (i < contextNodeList.length) {
                    int j = 0;
                    int nodeListCount = contextNodeList[i].getLength();
                    while (j < nodeListCount) {
                        this.evaluateXPathExpression(xpathExpr, contextNodeList[i].item(j), listOfNodeList);
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (XPathExpressionException xe) {
            throw new BadExpressionException(xe);
        }
        return listOfNodeList.toArray(new NodeList[listOfNodeList.size()]);
    }

    private void evaluateXPathExpression(XPathExpression xpathExpr, Node context, List<NodeList> listOfNodeList) throws XPathExpressionException {
        NodeList nodeList = (NodeList)xpathExpr.evaluate(context, XPathConstants.NODESET);
        if (nodeList != null) {
            listOfNodeList.add(nodeList);
        }
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }
}

