/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.smlvalidators;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ReferenceDescriptor;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationMessage;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ReferenceExtractor;
import org.eclipse.cosmos.rm.validation.internal.reference.ReferenceContext;
import org.eclipse.cosmos.rm.validation.internal.reference.URIReference;
import org.eclipse.cosmos.rm.validation.internal.reference.XPointer;
import org.eclipse.cosmos.rm.validation.internal.reference.XPointerExpression;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceValidator
extends AbstractSMLValidator {
    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry databuilderRegistry = DataBuilderRegistry.instance();
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ReferenceExtractor", new ReferenceExtractor());
    }

    @Override
    public boolean validate() {
        this.setTaskName(SMLValidationMessages.validationReferences);
        ReferenceExtractor referenceExtractor = (ReferenceExtractor)DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.ReferenceExtractor");
        List<ReferenceContext> referenceContextList = referenceExtractor.getContextReferences();
        NodeList lastNodeList = null;
        ReferenceDescriptor lastReference = null;
        int i = 0;
        int refContextCount = referenceContextList.size();
        while (i < refContextCount) {
            ReferenceContext referenceContext = referenceContextList.get(i);
            if (!referenceContext.isNilref()) {
                List<ReferenceDescriptor> referenceDescriptors = referenceContext.getReferenceDescriptors();
                int j = 0;
                int referenceDescCount = referenceDescriptors.size();
                while (j < referenceDescCount) {
                    ReferenceDescriptor currentReference = null;
                    try {
                        currentReference = referenceDescriptors.get(j);
                        URIReference uriReference = new URIReference(currentReference.getReference());
                        Node context = uriReference.retrieveDocumentDOM();
                        NodeList nodeList = null;
                        if (context == null) {
                            this.showWarning(SMLValidationMessages.warningUnresolvedReference, currentReference);
                        } else {
                            XPointerExpression xpointerExpression;
                            String fragment = uriReference.getFragment();
                            if (fragment != null && fragment.length() > 0 && ((nodeList = (NodeList)(xpointerExpression = XPointer.compile(uriReference.getFragment())).evaluate(referenceContext.getNamespaceContext(), context)) == null || nodeList.getLength() <= 0)) {
                                this.showWarning(SMLValidationMessages.warningUnresolvedReference, currentReference);
                            }
                        }
                        if (j == 0) {
                            lastNodeList = nodeList;
                            lastReference = currentReference;
                        } else if (lastNodeList == null && nodeList != null || !this.isSame(lastNodeList, nodeList)) {
                            this.showError(lastReference, currentReference);
                            if (this.shouldAbortOnError()) {
                                return false;
                            }
                        }
                    }
                    catch (Exception e) {
                        this.showError(SMLValidationMessages.errorReferenceResolving, currentReference, e);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean isSame(NodeList nodeList1, NodeList nodeList2) {
        if (nodeList1 == null) {
            return nodeList2 == null;
        }
        if (nodeList2 == null) {
            return false;
        }
        int nodeCount = nodeList1.getLength();
        if (nodeCount != nodeList2.getLength()) {
            return false;
        }
        int i = 0;
        while (i < nodeCount) {
            if (!nodeList1.item(i).equals(nodeList2.item(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void showError(ReferenceDescriptor lastReference, ReferenceDescriptor currentReference) {
        this.showError(NLS.bind((String)SMLValidationMessages.errorInconsistentReference, (Object[])new String[]{lastReference.getReference(), currentReference.getReference()}), lastReference);
    }

    private void showError(String message, ReferenceDescriptor uriReference, Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        this.showMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(uriReference.getFilePath(), uriReference.getLineNumber(), String.valueOf(NLS.bind((String)message, (Object)uriReference.getReference())) + " " + sw.getBuffer().toString()));
    }

    private void showError(String message, ReferenceDescriptor reference) {
        this.showMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(reference.getFilePath(), reference.getLineNumber(), message));
    }

    private void showWarning(String message, ReferenceDescriptor uriReference) {
        this.showMessage(AbstractValidationOutput.ValidationMessageFactory.createWarningMessage(uriReference.getFilePath(), uriReference.getLineNumber(), NLS.bind((String)message, (Object)uriReference.getReference())));
    }

    private void showMessage(IValidationMessage validationMessage) {
        IValidationOutput<String, Object> output = this.getValidationOutput();
        output.reportMessage(validationMessage);
    }
}

