/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.query.client;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.util.XMLUtils;
import org.eclipse.cosmos.dc.cmdbf.exception.CMDBfException;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.QueryOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IQuery;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.cmdbf.services.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class QueryServiceClient {
    private EndpointReference mdrepr = null;

    public QueryServiceClient(String epr) {
        this.mdrepr = new EndpointReference(epr);
    }

    public QueryServiceClient(EndpointReference epr) {
        this.mdrepr = epr;
    }

    public OMElement graphQuery(OMElement queryRequest) throws CMDBfException {
        try {
            Options options = new Options();
            options.setTo(this.mdrepr);
            options.setTransportInProtocol("http");
            options.setSoapVersionURI("http://www.w3.org/2003/05/soap-envelope");
            ServiceClient sender = new ServiceClient();
            sender.setOptions(options);
            OMElement result = sender.sendReceive(queryRequest);
            return result;
        }
        catch (Exception e) {
            throw new CMDBfException(e);
        }
    }

    public Element graphQuery(Element queryRequest) throws CMDBfException {
        try {
            OMElement request = XMLUtils.toOM((Element)queryRequest);
            OMElement result = this.graphQuery(request);
            return XMLUtils.toDOM((OMElement)result);
        }
        catch (Exception e) {
            throw new CMDBfException(e);
        }
    }

    public IQueryResult graphQuery(IQuery queryRequest) throws CMDBfException {
        try {
            StringWriter queryWriter = new StringWriter();
            queryRequest.toXML(queryWriter, 0);
            StringReader queryReader = new StringReader(queryWriter.toString());
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(queryReader);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement requestPayload = builder.getDocumentElement();
            OMElement result = this.graphQuery(requestPayload);
            IQueryResult resultObj = QueryOutputTransformer.transform((Reader)new StringReader(result.toString()));
            return resultObj;
        }
        catch (XMLStreamException e) {
            throw new CMDBfException(e);
        }
        catch (TransformerException te) {
            throw new CMDBfException(te);
        }
    }

    protected Element getWSDL() throws CMDBfException {
        try {
            String wsdlurl = this.mdrepr.getAddress() + "?wsdl";
            URL url = new URL(wsdlurl);
            URLConnection connection = url.openConnection();
            HttpURLConnection httpConn = (HttpURLConnection)connection;
            httpConn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            httpConn.setRequestMethod("GET");
            InputStream input = httpConn.getInputStream();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
            Element elem = doc.getDocumentElement();
            return elem;
        }
        catch (Exception e) {
            throw new CMDBfException(e);
        }
    }

    public Element getQueryServiceMetadata() throws CMDBfException {
        Element metadata = null;
        try {
            Element wsdl = this.getWSDL();
            NodeList list = wsdl.getElementsByTagName("queryServiceMetadata");
            if (list.getLength() > 0) {
                metadata = (Element)list.item(0);
            }
        }
        catch (Exception e) {
            throw new CMDBfException(e);
        }
        return metadata;
    }
}

