/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.receiver;

import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.receivers.AbstractInOutMessageReceiver;
import org.apache.axis2.util.XMLUtils;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CosmosMessageReceiver
extends AbstractInOutMessageReceiver
implements MessageReceiver {
    private Method findOperation(AxisOperation op, Class implClass) {
        block5: {
            Method method = (Method)op.getParameterValue("myMethod");
            if (method != null) {
                return method;
            }
            String methodName = op.getName().getLocalPart();
            try {
                method = implClass.getMethod(methodName, OMElement.class);
                if (!method.getReturnType().equals(OMElement.class)) break block5;
                try {
                    op.addParameter("myMethod", (Object)method);
                }
                catch (AxisFault axisFault) {
                    // empty catch block
                }
                return method;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    public void invokeBusinessLogic(MessageContext msgContext, MessageContext newmsgContext) throws AxisFault {
        OMElement request = msgContext.getEnvelope().getBody().getFirstElement();
        try {
            Object obj = this.getTheImplementationObject(msgContext);
            Class<?> implClass = obj.getClass();
            AxisOperation opDesc = msgContext.getAxisOperation();
            Method method = this.findOperation(opDesc, implClass);
            if (method == null) {
                throw new AxisFault(Messages.getMessage((String)"methodDoesNotExistInOut", (String)opDesc.getName().toString()));
            }
            OMElement result = (OMElement)method.invoke(obj, request);
            SOAPFactory fac = this.getSOAPFactory(msgContext);
            SOAPEnvelope envelope = fac.getDefaultEnvelope();
            if (result != null) {
                envelope.getBody().addChild((OMNode)result);
            }
            newmsgContext.setEnvelope(envelope);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)e).getTargetException();
                if (targetException != null && targetException instanceof CMDBfServiceException) {
                    SOAPEnvelope envelope = this.getSOAPFactory(msgContext).getDefaultEnvelope();
                    SOAPFault fault = this.createFault(request.getOMFactory(), (CMDBfServiceException)targetException);
                    if (fault != null) {
                        envelope.getBody().addChild((OMNode)fault);
                    }
                    newmsgContext.setEnvelope(envelope);
                }
                throw AxisFault.makeFault((Throwable)e);
            }
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    protected SOAPFault createFault(OMFactory factory, CMDBfServiceException e) {
        if (factory instanceof SOAP11Factory) {
            SOAP11Factory soap11factory = (SOAP11Factory)factory;
            return this.createSOAP11Fault(soap11factory, e);
        }
        if (factory instanceof SOAP12Factory) {
            SOAP12Factory soap12factory = (SOAP12Factory)factory;
            return this.createSOAP12Fault(soap12factory, e);
        }
        return null;
    }

    private SOAPFault createSOAP11Fault(SOAP11Factory soap11factory, CMDBfServiceException e) {
        String faultcode = null;
        QName subcodeqname = null;
        String reasonString = null;
        Node[] detailNodes = null;
        faultcode = this.getSOAP11Code(e.getCode());
        subcodeqname = this.getSubcodeQName(e.getSubCode());
        reasonString = e.getMessage();
        detailNodes = e.getDetails();
        SOAPFault soapfault = soap11factory.createSOAPFault();
        SOAPFaultDetail soapdetails = soap11factory.createSOAPFaultDetail(soapfault);
        SOAPFaultCode soapcode = soap11factory.createSOAPFaultCode(soapfault);
        SOAPFaultReason soapreason = soap11factory.createSOAPFaultReason(soapfault);
        soapcode.setText(faultcode);
        OMNamespace ns = soap11factory.createOMNamespace("http://cmdbf.org/schema/1-0-0/datamodel", "cmdbf");
        OMElement subcodeElement = soap11factory.createOMElement("Subcode", ns, (OMContainer)soapdetails);
        soap11factory.createOMText((OMContainer)subcodeElement, subcodeqname);
        soapreason.setText(reasonString);
        if (detailNodes != null) {
            this.setDetails(soapdetails, detailNodes);
        }
        return soapfault;
    }

    private SOAPFault createSOAP12Fault(SOAP12Factory soap12factory, CMDBfServiceException e) {
        String faultcode = null;
        QName subcodeqname = null;
        String reasonString = null;
        Node[] detailNodes = null;
        faultcode = this.getSOAP12Code(e.getCode());
        subcodeqname = this.getSubcodeQName(e.getSubCode());
        reasonString = e.getMessage();
        detailNodes = e.getDetails();
        SOAPFault soapfault = soap12factory.createSOAPFault();
        SOAPFaultDetail soapdetails = soap12factory.createSOAPFaultDetail(soapfault);
        SOAPFaultCode soapcode = soap12factory.createSOAPFaultCode(soapfault);
        SOAPFaultReason soapreason = soap12factory.createSOAPFaultReason(soapfault);
        SOAPFaultText soapfaultText = soap12factory.createSOAPFaultText(soapreason);
        SOAPFaultValue soapfaultcodevalue = soap12factory.createSOAPFaultValue(soapcode);
        soapfaultText.setText(reasonString);
        soapfaultcodevalue.setText(faultcode);
        if (detailNodes != null) {
            this.setDetails(soapdetails, detailNodes);
        }
        SOAPFaultSubCode soapsubcode = soap12factory.createSOAPFaultSubCode(soapcode);
        SOAPFaultValue faultsubcodevalue = soap12factory.createSOAPFaultValue(soapsubcode);
        faultsubcodevalue.setText(subcodeqname);
        return soapfault;
    }

    private String getSOAP11Code(int code) {
        String faultcode = null;
        switch (code) {
            case 0: {
                faultcode = "Client";
                break;
            }
            case 1: {
                faultcode = "Server";
            }
        }
        return faultcode;
    }

    private String getSOAP12Code(int code) {
        String faultcode = null;
        switch (code) {
            case 0: {
                faultcode = "Sender";
                break;
            }
            case 1: {
                faultcode = "Receiver";
            }
        }
        return faultcode;
    }

    private QName getSubcodeQName(int subcode) {
        QName subcodeqname = null;
        String dataModelNamespace = "http://cmdbf.org/schema/1-0-0/datamodel";
        switch (subcode) {
            case 0: {
                subcodeqname = new QName(dataModelNamespace, "UnkownTemplateID", "cmdbf");
                break;
            }
            case 1: {
                subcodeqname = new QName(dataModelNamespace, "InvalidPropertyType", "cmdbf");
                break;
            }
            case 2: {
                subcodeqname = new QName(dataModelNamespace, "XPathError", "cmdbf");
                break;
            }
            case 3: {
                subcodeqname = new QName(dataModelNamespace, "UnsupportedConstraint", "cmdbf");
                break;
            }
            case 4: {
                subcodeqname = new QName(dataModelNamespace, "UnsupportedSelector", "cmdbf");
                break;
            }
            case 5: {
                subcodeqname = new QName(dataModelNamespace, "QueryError", "cmdbf");
                break;
            }
            case 6: {
                subcodeqname = new QName(dataModelNamespace, "InvalidRecord", "cmdbf");
                break;
            }
            case 7: {
                subcodeqname = new QName(dataModelNamespace, "UnsupportRecordType", "cmdbf");
                break;
            }
            case 8: {
                subcodeqname = new QName(dataModelNamespace, "InvalidMDR", "cmdbf");
                break;
            }
            case 9: {
                subcodeqname = new QName(dataModelNamespace, "RegisrationError", "cmdbf");
                break;
            }
            case 16: {
                subcodeqname = new QName(dataModelNamespace, "DeregistrationError", "cmdbf");
            }
        }
        return subcodeqname;
    }

    private void setDetails(SOAPFaultDetail soapdetails, Node[] detailNodes) {
        for (int i = 0; i < detailNodes.length; ++i) {
            Node node = detailNodes[i];
            if (node instanceof Element) {
                Element elem = (Element)node;
                try {
                    soapdetails.addChild((OMNode)XMLUtils.toOM((Element)elem));
                }
                catch (Exception e) {}
                continue;
            }
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer trans = tf.newTransformer();
                PipedOutputStream os = new PipedOutputStream();
                trans.transform(new DOMSource(node), new StreamResult(os));
                PipedInputStream is = new PipedInputStream(os);
                soapdetails.addChild(XMLUtils.toOM((InputStream)is));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

