/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.BaseProperty;
import org.w3c.dom.Node;

public class SimpleTypeProperty
extends BaseProperty {
    private boolean booleanValue;
    private int intValue;
    private double doubleValue;
    private int type;

    public SimpleTypeProperty(Node node, boolean value) {
        super(node.getNamespaceURI(), node.getLocalName());
        this.booleanValue = value;
        this.type = 1;
    }

    public SimpleTypeProperty(Node node, int value) {
        super(node.getNamespaceURI(), node.getLocalName());
        this.intValue = value;
        this.type = 2;
    }

    public SimpleTypeProperty(Node node, double value) {
        super(node.getNamespaceURI(), node.getLocalName());
        this.doubleValue = value;
        this.type = 3;
    }

    public boolean equals(Object o, boolean caseSensitive) throws CMDBfServiceException {
        return this.operation(o, 0);
    }

    public boolean greater(Object o) throws CMDBfServiceException {
        return this.operation(o, 1);
    }

    public boolean less(Object o) throws CMDBfServiceException {
        return this.operation(o, 2);
    }

    public boolean operation(Object o, int operation) throws CMDBfServiceException {
        if (o == null) {
            return false;
        }
        switch (this.type) {
            case 2: {
                try {
                    int operand = Integer.parseInt(o.toString());
                    return operation == 0 ? this.intValue == operand : (operation == 1 ? this.intValue > operand : (operation == 2 ? this.intValue < operand : false));
                }
                catch (NumberFormatException numberFormatException) {
                    throw this.propertyTypeMismatch();
                }
            }
            case 3: {
                try {
                    double operand = Double.parseDouble(o.toString());
                    return operation == 0 ? this.doubleValue == operand : (operation == 1 ? this.doubleValue > operand : (operation == 2 ? this.doubleValue < operand : false));
                }
                catch (NumberFormatException numberFormatException) {
                    throw this.propertyTypeMismatch();
                }
            }
            case 1: {
                String str = o.toString();
                if (str == null || !str.equalsIgnoreCase("true") && !str.equalsIgnoreCase("false")) {
                    throw this.propertyTypeMismatch();
                }
                boolean operand = Boolean.parseBoolean(o.toString());
                return operation == 0 ? this.booleanValue == operand : false;
            }
        }
        return false;
    }
}

