/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.registration.client;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.util.XMLUtils;
import org.eclipse.cosmos.dc.cmdbf.exception.CMDBfException;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.DeregistrationOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterRequest;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.IDeregisterResponse;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.RegistrationOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterRequest;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IRegisterResponse;
import org.eclipse.cosmos.dc.cmdbf.services.transform.TransformerException;
import org.w3c.dom.Element;

public class RegistrationServiceClient {
    private EndpointReference serviceEPR = null;

    public RegistrationServiceClient(String epr) {
        this.serviceEPR = new EndpointReference(epr);
    }

    public RegistrationServiceClient(EndpointReference epr) {
        this.serviceEPR = epr;
    }

    public Element register(Element registrationRequest) throws CMDBfException {
        try {
            OMElement request = XMLUtils.toOM((Element)registrationRequest);
            OMElement result = this.register(request);
            return XMLUtils.toDOM((OMElement)result);
        }
        catch (Exception e) {
            throw new CMDBfException(e);
        }
    }

    public IRegisterResponse register(IRegisterRequest registrationRequest) throws CMDBfException {
        try {
            StringWriter writer = new StringWriter();
            registrationRequest.toXML(writer, 0);
            StringReader regReader = new StringReader(writer.toString());
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(regReader);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement requestPayload = builder.getDocumentElement();
            OMElement result = this.register(requestPayload);
            IRegisterResponse resultObj = RegistrationOutputTransformer.transform((Reader)new StringReader(result.toString()));
            return resultObj;
        }
        catch (XMLStreamException e) {
            throw new CMDBfException(e);
        }
        catch (TransformerException te) {
            throw new CMDBfException(te);
        }
    }

    public OMElement register(OMElement registrationRequest) throws CMDBfException {
        try {
            Options options = new Options();
            options.setTo(this.serviceEPR);
            options.setTransportInProtocol("http");
            ServiceClient sender = new ServiceClient();
            sender.setOptions(options);
            OMElement result = sender.sendReceive(registrationRequest);
            return result;
        }
        catch (Exception e) {
            throw new CMDBfException(e);
        }
    }

    public Element deregister(Element deregistrationRequest) throws CMDBfException {
        try {
            OMElement request = XMLUtils.toOM((Element)deregistrationRequest);
            OMElement result = this.deregister(request);
            return XMLUtils.toDOM((OMElement)result);
        }
        catch (Exception e) {
            throw new CMDBfException(e);
        }
    }

    public IDeregisterResponse deregister(IDeregisterRequest deregistrationRequest) throws CMDBfException {
        try {
            StringWriter writer = new StringWriter();
            deregistrationRequest.toXML(writer, 0);
            StringReader reader = new StringReader(writer.toString());
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(reader);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement requestPayload = builder.getDocumentElement();
            OMElement result = this.deregister(requestPayload);
            IDeregisterResponse resultObj = DeregistrationOutputTransformer.transform((Reader)new StringReader(result.toString()));
            return resultObj;
        }
        catch (XMLStreamException e) {
            throw new CMDBfException(e);
        }
        catch (TransformerException te) {
            throw new CMDBfException(te);
        }
    }

    public OMElement deregister(OMElement deregistrationRequest) throws CMDBfException {
        try {
            Options options = new Options();
            options.setTo(this.serviceEPR);
            options.setTransportInProtocol("http");
            ServiceClient sender = new ServiceClient();
            sender.setOptions(options);
            OMElement result = sender.sendReceive(deregistrationRequest);
            return result;
        }
        catch (Exception e) {
            throw new CMDBfException(e);
        }
    }
}

