/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.input.artifacts;

import java.io.StringWriter;
import java.net.URI;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IItemList;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRelationshipList;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRequest;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.RegisterInputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;

public abstract class AbstractRequest
implements IRequest {
    private URI mdrId;
    private IItemList itemList;
    private IRelationshipList relationshipList;

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write("<cmdbf:" + this.getRequestElement() + " xmlns:" + "cmdbf" + "=\"" + "http://cmdbf.org/schema/1-0-0/datamodel" + "\"" + ">" + ICMDBfServicesConstants.nl);
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)(indent + 1));
        writer.write(CMDBfServicesUtil.beginTagFor((String)"cmdbf:mdrId"));
        writer.write(this.getMdrId().toString());
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor((String)"cmdbf:mdrId")) + ICMDBfServicesConstants.nl);
        if (this.itemList != null) {
            this.itemList.toXML(writer, indent + 1);
        }
        if (this.relationshipList != null) {
            this.relationshipList.toXML(writer, indent + 1);
        }
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor((String)("cmdbf:" + this.getRequestElement()))) + ICMDBfServicesConstants.nl);
    }

    protected abstract String getRequestElement();

    protected abstract boolean isIdList();

    public URI getMdrId() {
        return this.mdrId;
    }

    public void setMdrId(URI mdrId) {
        this.mdrId = mdrId;
    }

    public void addItem(IItem item) {
        this.getItemListInit().addItem(item);
    }

    public IItemList getItemList() {
        return this.itemList;
    }

    private IItemList getItemListInit() {
        this.initItemList();
        return this.itemList;
    }

    private void initItemList() {
        if (this.itemList == null) {
            this.itemList = RegisterInputArtifactFactory.getInstance().createItemList(this.isIdList());
        }
    }

    public void addRelationship(IRelationship relationship) {
        this.getRelationshipListInit().addRelationship(relationship);
    }

    public IRelationshipList getRelationshipList() {
        return this.relationshipList;
    }

    private IRelationshipList getRelationshipListInit() {
        this.initRegisterRequest();
        return this.relationshipList;
    }

    private void initRegisterRequest() {
        if (this.relationshipList == null) {
            this.relationshipList = RegisterInputArtifactFactory.getInstance().createRelationshipList(this.isIdList());
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.itemList == null ? 0 : this.itemList.hashCode());
        result = 31 * result + (this.mdrId == null ? 0 : this.mdrId.hashCode());
        result = 31 * result + (this.relationshipList == null ? 0 : this.relationshipList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractRequest other = (AbstractRequest)obj;
        if (this.itemList == null ? other.itemList != null : !this.itemList.equals(other.itemList)) {
            return false;
        }
        if (this.mdrId == null ? other.mdrId != null : !this.mdrId.equals(other.mdrId)) {
            return false;
        }
        return !(this.relationshipList == null ? other.relationshipList != null : !this.relationshipList.equals(other.relationshipList));
    }
}

