/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.stat.datamgr.axis;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Vector;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.Parameter;
import org.eclipse.cosmos.common.exceptions.CosmosException;
import org.eclipse.cosmos.dc.stat.datamgr.ws.common.DataSourceKeyset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticalDataManager {
    private int _dset_id;
    private int _kset_id;
    private String namespace = "http://org.eclipse.cosmos.dc.stat.datamgr.ws";
    private String _derby_home = null;

    public void init(ServiceContext serviceContext) {
        Parameter p = serviceContext.getAxisService().getParameter("derby.system.home");
        if (p != null) {
            this._derby_home = (String)p.getValue();
        }
    }

    public OMElement getStatDataForSources(String dataset, String keyset, int start, int size) throws CosmosException {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(this.namespace, "ns");
        OMElement method = fac.createOMElement("getStatDataForSourcesResponse", omNs);
        this.SDFS(method, dataset, keyset, start, size);
        return method;
    }

    public OMElement getDatasourceKeysets() throws CosmosException {
        boolean i = false;
        Object tstr = null;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(this.namespace, "ns");
        OMElement method = fac.createOMElement("getDatasourceKeysets", omNs);
        Vector<DataSourceKeyset> keysets = this.getSources();
        if (keysets == null) {
            OMElement value = fac.createOMElement("Error", omNs);
            value.addChild((OMNode)fac.createOMText((OMContainer)value, "Couldn't get sources"));
            method.addChild((OMNode)value);
        } else {
            for (DataSourceKeyset ds : keysets) {
                String v = ds.getDataSet();
                String k = ds.getKeySet();
                OMElement value = fac.createOMElement("Dataset", omNs);
                value.addChild((OMNode)fac.createOMText((OMContainer)value, v));
                method.addChild((OMNode)value);
                value = fac.createOMElement("Keyset", omNs);
                value.addChild((OMNode)fac.createOMText((OMContainer)value, k));
                method.addChild((OMNode)value);
            }
        }
        return method;
    }

    private Connection getConnection() {
        Connection conn = null;
        Object[] urlArgs = new Object[]{"dummy"};
        String url = MessageFormat.format("jdbc:derby:cosmosdb;create=true", urlArgs);
        Driver d = null;
        System.out.println("derby " + this._derby_home);
        System.setProperty("derby.system.home", this._derby_home);
        try {
            d = (Driver)Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            DriverManager.registerDriver(d);
            conn = DriverManager.getConnection(url);
            DriverManager.deregisterDriver(d);
        }
        catch (Exception ex) {
            System.out.println("failed to connect to " + url);
            System.out.println("exception = " + ex.getMessage());
            return null;
        }
        System.out.println("connected to " + url);
        return conn;
    }

    private Vector<DataSourceKeyset> getSources() throws CosmosException {
        Connection conn = null;
        Vector<String> vn = null;
        Vector<Integer> vid = null;
        Vector<DataSourceKeyset> kn = null;
        Object Iv = null;
        Object Ik = null;
        Object v = null;
        Object k = null;
        Object ret = null;
        boolean idx = false;
        Object ds = null;
        vn = new Vector<String>();
        vid = new Vector<Integer>();
        kn = new Vector<DataSourceKeyset>();
        conn = this.getConnection();
        if (conn == null) {
            return null;
        }
        this.fillInDataSets(conn, vn, vid);
        this.fillInKeySets(conn, vn, vid, kn);
        return kn;
    }

    private void fillInKeySets(Connection conn, Vector<String> vn, Vector<Integer> vid, Vector<DataSourceKeyset> kn) {
        ResultSet rs = null;
        Object stmt = null;
        String query = null;
        Iterator<Integer> It = null;
        Iterator<String> Itv = null;
        Iterator Itk = null;
        Integer itmp2 = null;
        int ivalue = 0;
        Vector<Integer> kid = null;
        int id = 0;
        String s = null;
        Integer I = null;
        DataSourceKeyset ds = null;
        String v = null;
        It = vid.iterator();
        Itv = vn.iterator();
        while (It.hasNext()) {
            itmp2 = It.next();
            ivalue = itmp2;
            v = Itv.next();
            query = new String("select KEY_ENTRY from COSMOS_STAT.STATISTICAL_OBSERVATION where DATA_SET_ID = " + ivalue);
            rs = this.DoQuery(conn, query);
            kid = new Vector<Integer>();
            try {
                while (rs.next()) {
                    id = rs.getInt("KEY_ENTRY");
                    I = new Integer(id = this.Translate(conn, id));
                    if (kid.contains(I)) continue;
                    kid.add(I);
                }
            }
            catch (Exception e) {
                System.out.println("Could not get keyset entry " + e.getMessage());
                return;
            }
            for (Integer itmp2 : kid) {
                ivalue = itmp2;
                s = this.getKeySetName(conn, ivalue);
                ds = new DataSourceKeyset(v, s);
                kn.add(ds);
            }
        }
    }

    private void fillInDataSets(Connection conn, Vector<String> vn, Vector<Integer> vid) {
        ResultSet rs = null;
        Statement stmt = null;
        String query = new String("select * from COSMOS_STAT.STATISTICAL_DATASET");
        rs = this.DoQuery(conn, query);
        try {
            while (rs.next()) {
                String name = rs.getString("NAME");
                if (name == null) {
                    name = new String("<NULL>");
                }
                vn.add(name);
                int id = rs.getInt("ID");
                Integer I = new Integer(id);
                vid.add(I);
            }
        }
        catch (Exception ex) {
            System.out.println("Retrival error: " + ex.getMessage());
            return;
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception ex2) {
            System.out.println("EEK!");
            return;
        }
    }

    private ResultSet DoQuery(Connection conn, String query) {
        Statement stmt = null;
        ResultSet ret = null;
        System.out.println("Trying query " + query);
        try {
            stmt = conn.createStatement();
            ret = stmt.executeQuery(query);
        }
        catch (Exception e) {
            System.out.println("Select error: " + e.getMessage());
            return null;
        }
        System.out.println("ok " + query);
        return ret;
    }

    private int Translate(Connection conn, int id) {
        ResultSet rs = null;
        String query = new String("select KEYSET from COSMOS.KEY_SET_ENTRY where ID = " + id);
        int ret = 0;
        rs = this.DoQuery(conn, query);
        try {
            rs.next();
            ret = rs.getInt("KEYSET");
        }
        catch (Exception e) {
            System.out.println("Couldn't get ID");
            return 0;
        }
        return ret;
    }

    private String getKeySetName(Connection conn, int id) {
        ResultSet rs = null;
        String ret = null;
        String query = new String("select NAME from COSMOS.KEY_SET where ID = " + id);
        rs = this.DoQuery(conn, query);
        try {
            rs.next();
            ret = rs.getString("NAME");
        }
        catch (Exception e) {
            System.out.println("Couldn't get ID");
            return null;
        }
        return ret;
    }

    private void SDFS(OMElement elem, String dataset, String keyset, int start, int size) throws CosmosException {
        Connection conn = null;
        this._dset_id = 0;
        this._kset_id = 0;
        conn = this.getConnection();
        if (conn == null) {
            return;
        }
        this.SetDSetId(dataset);
        this.SetKSetId(keyset);
        this.DoObservation(elem, conn, start, size);
    }

    private void SetKSetId(String lookup) throws CosmosException {
        Connection conn = null;
        ResultSet rs = null;
        String query = null;
        conn = this.getConnection();
        if (conn == null) {
            return;
        }
        query = new String("select ID from COSMOS.KEY_SET where NAME = '" + lookup + "'");
        rs = this.DoQuery(conn, query);
        try {
            rs.next();
            this._kset_id = rs.getInt("ID");
        }
        catch (Exception e) {
            System.out.println("Couldn't get ID");
        }
    }

    private void SetDSetId(String lookup) throws CosmosException {
        Connection conn = null;
        ResultSet rs = null;
        String query = null;
        conn = this.getConnection();
        if (conn == null) {
            return;
        }
        query = new String("select ID from COSMOS_STAT.STATISTICAL_DATASET where NAME = '" + lookup + "'");
        rs = this.DoQuery(conn, query);
        try {
            rs.next();
            this._dset_id = rs.getInt("ID");
        }
        catch (Exception e) {
            System.out.println("Couldn't get ID");
        }
    }

    private void DoObservation(OMElement elem, Connection conn, int start, int size) {
        ResultSet rs = null;
        Statement stmt = null;
        String query = null;
        int cnt = 0;
        int idx = 0;
        long l = 0L;
        double db = 0.0;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(this.namespace, "ns");
        query = new String("select * from COSMOS_STAT.STATISTICAL_OBSERVATION where DATA_SET_ID = " + this._dset_id + " and KEY_ENTRY = " + this._kset_id);
        rs = this.DoQuery(conn, query);
        try {
            while (rs.next()) {
                if (idx >= start) {
                    Timestamp d = rs.getTimestamp("CAPTURE_TIME");
                    OMElement value = fac.createOMElement("CAPTURE_TIME", omNs);
                    value.addChild((OMNode)fac.createOMText((OMContainer)value, d.toString()));
                    elem.addChild((OMNode)value);
                    String svalue = rs.getString("STRING_VALUE");
                    if (svalue == null) {
                        l = rs.getLong("INTEGRAL_VALUE");
                        if (l == 0L) {
                            db = rs.getDouble("DECIMAL_VALUE");
                            value = fac.createOMElement("DECIMAL_VALUE", omNs);
                            value.addChild((OMNode)fac.createOMText((OMContainer)value, String.valueOf(db)));
                            elem.addChild((OMNode)value);
                        } else {
                            value = fac.createOMElement("INTEGRAL_VALUE", omNs);
                            value.addChild((OMNode)fac.createOMText((OMContainer)value, String.valueOf(l)));
                            elem.addChild((OMNode)value);
                        }
                    } else {
                        value = fac.createOMElement("STRING_VALUE", omNs);
                        value.addChild((OMNode)fac.createOMText((OMContainer)value, svalue));
                        elem.addChild((OMNode)value);
                    }
                    ++cnt;
                }
                ++idx;
                if (cnt != size) continue;
                break;
            }
        }
        catch (Exception ex) {
            System.out.println("Retrival error: " + ex.getMessage());
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception ex2) {
            System.out.println("EEK!");
        }
    }
}

