/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElementCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphCollection
implements IGraphElementCollection {
    private String id;
    private List<IGraphElement> elements;
    private boolean startingContext;

    public AbstractGraphCollection(String templateId) {
        this.id = templateId;
        this.elements = new ArrayList<IGraphElement>();
    }

    protected List<IGraphElement> getCollection() {
        return this.elements;
    }

    @Override
    public IGraphElement[] getElements() {
        return this.elements.toArray(new IGraphElement[this.elements.size()]);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return this == obj ? true : (obj == null || this.getClass() != obj.getClass() ? false : this.checkEquality(obj));
    }

    private boolean checkEquality(Object obj) {
        AbstractGraphCollection other = (AbstractGraphCollection)obj;
        return !(this.elements == null && other.getCollection() != null || !this.elements.equals(other.getCollection()) || this.id == null && other.getId() != null) && this.id.equals(other.getId());
    }

    public void clear() {
        this.getCollection().clear();
    }

    @Override
    public boolean isEmpty() {
        return this.isStartingContext() ? false : this.getCollection().isEmpty();
    }

    @Override
    public void setElements(IGraphElement[] elements) {
        this.elements = new ArrayList<IGraphElement>();
        int i = 0;
        while (i < elements.length) {
            this.elements.add(elements[i]);
            ++i;
        }
    }

    public String getId() {
        return this.id;
    }

    @Override
    public int getSize() {
        return this.elements.size();
    }

    public boolean isStartingContext() {
        return this.startingContext;
    }

    public void setStartingContext(boolean startingContext) {
        this.startingContext = startingContext;
    }

    @Override
    public void addElement(IGraphElement element) {
        if (this.elements != null) {
            this.elements.add(element);
        }
    }

    @Override
    public void removeElement(IGraphElement element) {
        if (this.elements == null) {
            return;
        }
        this.elements.remove(element);
    }

    protected void setElements(List<IGraphElement> elements) {
        this.elements = elements;
    }
}

