/*******************************************************************************
 * Copyright (c) 2007, 2008 CA, Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA Inc. - initial API and implementation
 *     IBM - Bug fix 220495
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.DeRegisterDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.utility.common");
dojo.require("dijit.Dialog");
dojo.require("dijit.form.Button");
dojo.require("dijit.form.TextBox");
dojo.require("dijit.form.Textarea");

dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.query.DeRegisterDialog",
	// superclass	
   org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery,
	{
		labelDialogQuery:"",
		_message: dojo.i18n.getLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "widget"),
		builder:null,
		statusService:"json?service=org/eclipse/cosmos/internal/dr/drs/service/outputter/StatusResponseOutputter",		
		brokerService:"json?service=org/eclipse/cosmos/internal/dr/drs/service/outputter/BrokerOutputter",		
		bindInput: function(data, callbackMethod){	   
			var registerEPR = this.UIContext.getService(data, "http://cmdbf.org/schema/1-0-0/registration");
			if (registerEPR == null)
				return;  
	   
			this.builder = new org.eclipse.cosmos.provisional.dr.ps.components.widget.DeRegisterDialog({callback: callbackMethod, labelQuery:this.labelDialogQuery,statusService: this.statusService, brokerService:this.brokerService, title:this.title, epr:registerEPR, UIContext:this.UIContext});
			this.builder.show();		
		},
		render: function(input){
			this.builder.destroy();
			this.builder = null;
			return input;
		}
	}
); 

 dojo.declare(
	"org.eclipse.cosmos.provisional.dr.ps.components.widget.DeRegisterDialog",
	[dijit._Widget, dijit._Templated, dijit._Container], 
	{
	 	rows:12,
	 	cols:80,
		labelQuery:"",
		_message: dojo.i18n.getLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "widget"),
		templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/DeRegisterDialog.html"),
		widgetsInTemplate: true,
		widgetId: "deregisterDialog",
		gridwidget: null,
		mdrlist: null,
		cmdbfEPR: null,
		mdrEPRs: null,
		show: function(){
			this.dialogBox.show();
		},
		
		onDeregister: function(){
			
			var _self = this;
			if ( gridwidget.selection.getSelectedCount() > 0 ){
				var selection = gridwidget.selection.getSelected();

				//
				// build the selected MDR EPRs parameters for the outputter
				//
				this.mdrEPRs = "";
				for(var i=0, l=selection.length; i<l; i++){
					var index = selection[i];
					var mdr = mdrlist[index];
					this.mdrEPRs += "&mdrEPR" + i + "=" + mdr[1];
				}
				// re-populate the grid with the registration results
				this.UIContext.submitQuery(
						
					// invoke the Status Response outputter to register the items 
					{queryObject:new org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery({queryHandler:_self.statusService+"&deregister=true&cmdbfEPR="+this.cmdbfEPR + this.mdrEPRs}), 
					onItem:function(response){
											
		                // define the grid view with columns 
		                var deregview = {
		                        cells: [[
			                            {name: "instance Id",       field: 0, width: "100px"},
			                            {name: "accepted/declined", field: 1, width: "200px" }
		                          ]
		                        ]
		                };
		                // define the grid layout containing the view
		                var dereglayout = [ deregview ];
						
						// create a model from the outputter JSON response
						var deregmodel = new dojox.grid.data.Table(null, response);
						
						gridwidget.autoHeight = true;	// turn on autoHeight
						gridwidget.autoWidth = true;	// turn on autoWidth
		
						// set the grid model
						gridwidget.setModel( deregmodel );
		
						// set the grid layout
						gridwidget.setStructure(dereglayout);
								
						// redraw the grid
						gridwidget.render();
								
					}, queryProp:"query"}
				);
				
				var deregcancel = dijit.byId("deregcancel");
				deregcancel.setLabel( "Ok" );
				
				var deregbutton = dijit.byId("deregbutton");
				deregbutton.destroy();
				
				var dereglabel = document.getElementById("dereglabel");
				dereglabel.textContent = this._message.DEREGISTER_DLG_RESULT;
				
			} else {
				alert("No MDRs have been selected");
			}
		},
		
		onCancel: function(){
			var deregcancel = dijit.byId("deregcancel");
			deregcancel.destroy();

			this.dialogBox.onCancel();
			this.destroy();
		},
		destroy: function(){
			var tempWidget = dijit.byId("deregisterGrid");
			if ( tempWidget ){
				tempWidget.destroy();
			}
			
			var tempButton = dijit.byId("deregbutton");
			if ( tempButton ){
				tempButton.destroy();
			}
			
			var tempLabel = dijit.byId("dereglabel");
			if ( tempLabel ){
				tempLabel.destroy();
			}
			if ( this.dialogBox ){
				this.dialogBox.destroy();
			}
			this.inherited(arguments);
		},
		postMixInProperties: function(){
			//call superclass
			org.eclipse.cosmos.provisional.dr.ps.components.widget.DeRegisterDialog.superclass.postMixInProperties.apply(this, arguments);
		},
		
		postCreate: function(){
			//call superclass
			org.eclipse.cosmos.provisional.dr.ps.components.widget.DeRegisterDialog.superclass.postCreate.apply(this, arguments);
			var idLength = this.id.length;
			this.dialogBox = dijit.byId(this.widgetId);
			this.cmdbfEPR = this.epr;
			
			var deregbutton = dijit.byId("deregbutton");
			deregbutton.setLabel( "Deregister" );

			var deregcancel = dijit.byId("deregcancel");
			deregcancel.setLabel( "Cancel" );
			
			var dereglabel = document.getElementById("dereglabel");
			dereglabel.textContent = this._message.DEREGISTER_DLG_COMMENT;
						
            // get the grid widget from the page
			gridwidget = dijit.byId("deregisterGrid");
			var _self = this;			// populate the grid with MDRs
			this.UIContext.submitQuery(
					
				// invoke the Broker outputter to return a list of MDRs to the onItem callback function
				{queryObject:new org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery({queryHandler:_self.brokerService+"&query=mdr&epr="+escape(this.epr)}), 
				onItem:function(response){
					
					mdrlist = response;
					
	                // define the grid view with columns 
	                var deregview = {
	                        cells: [[
		                            {name: 'MDR', field: 0, width: "300px"}
	                          ]
	                        ]
	                };
	                // define the grid layout containing the view
	                var dereglayout = [ deregview ];
					
					// create a model from the outputter JSON response
					var deregmodel = new dojox.grid.data.Table(null, response);
					
					//gridwidget.autoHeight = true;	// turn on autoHeight
					gridwidget.autoWidth = true;	// turn on autoWidth

					// set the grid model
					gridwidget.setModel( deregmodel );
	
					// set the grid layout
					gridwidget.setStructure(dereglayout);

					// redraw the grid
					gridwidget.render();

				}, queryProp:"query"}
			);
		}
		
	}
);      
