/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator");
dojo.require("dijit.Menu");
dojo.require("dijit.Tree");
dojo.require("dijit.TitlePane");
dojo.require("dijit.layout.ContentPane");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.data.LazyLoadStore");


dojo.declare(
	// class
	"org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator",

	// superclass	
	[dijit.Tree],
	
	// member variables/functions
	{
		//summary: This class provides a tree widget that gets its content from a url 
		//description: This widget has several key features:
		//              1.  Displays icons next to children nodes
		//              2.  Lazy loads nodes
		//              3.  Constructs menu options that are dynamically created.
		//              4.  Able to add and remove nodes to the tree
		//              5.  When a node is selected the contents of the node is published to a list of topics
		//initQueryHandler: String
		//   provides the url that will get the tree model that the tree renders
	    initQueryHandler: null,
	    //progressNode: DOMElement
	    //  html node that shows the onload progress indicator
	    progressNode: null,
	    //progressDescription:String
	    //  text string that contains the progress description
	    progressDescription: null,
	    //rollerImagePath: String
	    //  url path to the progress indicator icon
		rollerImagePath:dojo.moduleUrl("dojox","off/resources/roller.gif").uri,
		//publish: Array of Strings
		//  a list of topics that will be published to when the user selects a node
		publish:[],
		create: function(params, srcNodeRef) {
		//summary: the create method for this widget
		//description: This method will create a lazy load store based on the url passed into the params.initQueryhandler
			var oldMenu= dijit.byId(this.id+"_menu");
			if (oldMenu)
				oldMenu.destroy();
			if (params.initQueryHandler != null){
				if ((params.contextMap) && (params.contextMap.object)){
					params.initQueryHandler = params.initQueryHandler+"&id="+params.contextMap.object;
				}
				params.store=new org.eclipse.cosmos.provisional.dr.ps.components.data.LazyLoadStore({url:params.initQueryHandler});
				dojo.connect(params.store, "responseError", this, "destroyProgress");
				params.store.UIContext = params.UIContext;														
			}
			org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator.superclass.create.apply(this, arguments);
		},
		getIconClass: function(/*dojo.data.Item*/ item){
			// summary: user overridable function to return CSS class name to display icon
		    if ((item) && (item.nodeClass)){
				initParam = this.dataMap[item.nodeClass];
				if (initParam){
					return initParam.icon;
					}
			}			
		},		
		postMixInProperties: function(){
			//summary: postMixinProperties method for this widget
			//description: initializes the menu for the tree
			var cell = document.createElement("ul");
			cell.setAttribute("style", "display:none;");
			cell.setAttribute("id", this.id+"_menu");
			this.parentWidget.domNode.appendChild(cell);
			this.menu = new dijit.Menu({},cell);	
			org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator.superclass.postMixInProperties.apply(this, arguments);
		},
		destroy: function(){
			//summary: destroy method for this widget
			this.menu.destroy();
			org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator.superclass.destroy.apply(this, arguments);
		},		
		createContextMenu: function(e){
			//summary: constructs the menu based on the node that was selected
			var menu = this.menu;
			this.menu.getChildren().forEach(function(i){menu.removeChild(i);});
			var tn = dijit.getEnclosingWidget(e.target);
			var itemMap = this.dataMap[tn.item.nodeClass];
			var contextMenuFactory = null;
			if ((itemMap) && (itemMap.menuType)){
				if (dojo.isArray(itemMap.menuType)){
					for (i=0;i < itemMap.menuType.length;i++){
						contextMenuFactory = this.UIContext.createObject(itemMap.menuType[i]);
						contextMenuFactory.nodeFactory = this.nodeFactory;
						contextMenuFactory.UIContext = this.UIContext;
						contextMenuFactory.sourceObject=this;		
						contextMenuFactory.createContextMenu(this.menu,tn,tn.item.nodeClass);
					}
				}
				else{
					contextMenuFactory = this.UIContext.createObject(itemMap.menuType);
					contextMenuFactory.nodeFactory = this.nodeFactory;
					contextMenuFactory.UIContext = this.UIContext;
					contextMenuFactory.sourceObject=this;		
					contextMenuFactory.createContextMenu(this.menu,tn,tn.item.nodeClass);
				}
			}
			
		},
	    treeHandler: function(/*Object*/message){
			//summary: This method is called when the user selects a node
			//description: The message parameter contains the node that was selected.  The message parameter is cloned and published to 
			//  topics specified by the the publish memeber variable of this class.
		  if (message.event != 'execute') {
    		return;
  			}
			if (typeof(this.publish) != 'undefined'){
					for (i=0;i < this.publish.length;i++){
					 	    //lets clone the information we're going to send to another widget since we don't want the other
					 	    //widget modifying our content
							var cloneMap = new Object();
					 	    dojo.mixin(cloneMap,message.node.item);
					 	    //let tag the data we're going to send so that the consumer of this data knows where the data came from
					 	    cloneMap.nodeClass = this.attachPoint + " " +cloneMap.nodeClass;
					 	    if (message.mixinParams){
						 	    dojo.mixin(cloneMap, message.mixinParams);
					 	    }
					 	    this.addToMessage(cloneMap);
							dojo.publish(this.publish[i], [{contextMap:cloneMap}]);
		 			}
 			}	    
	    },
	    addToMessage: function(message){	    	
	    	//summary: convenient method that is called before publishing the message when a user selects a node
	    	//description: this method can be ovveridden to add additional properties to the message before publishing
	    },
		mayHaveChildren: function(/*dojo.data.Item*/ item){
			var initParam = this.dataMap[item.nodeClass];
			var hasChildren = false;			
			//check to see if this node has an expand query
			if ((initParam) && (typeof(initParam['expandQuery'])!='undefined')){
				//append query to item so that we don't have to make lookup again
				item.expandQuery = initParam.expandQuery;
				hasChildren = true;
			}
			if (hasChildren == false){
				hasChildren = org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator.superclass.mayHaveChildren.apply(this, arguments);
			}
			return hasChildren;
	
		},
		makeNodeFolder: function(el){
			//summary: displays an icon next to nodes that have been added to the tree.
		    if (el.item.nodeClass){
				initParam = this.dataMap[el.item.nodeClass];			
				if (initParam){
						//check to see if this node has an expand query
						if (typeof(initParam['expandQuery'])!='undefined'){
							el.item.isExpandable = true;
							}
				}
		    }
			dojo.connect(el,"addChild", this, "makeNodeFolder");
		},	    
		postCreate: function(){
			//summary: postCreate method for this widget
			//description: sets up the pop-up menu and handlers used to manage the tree nodes
			// when we right-click anywhere on the tree, make sure we open the menu		  	
			this.menu.bindDomNode(this.domNode);				
			dojo.connect(this.menu, "_openMyself", this, this.createContextMenu);
			//subscribe to node selection topic
		  	dojo.subscribe(this.id, this, this.treeHandler);
		  	dojo.connect(this, "addChild", this, this.makeNodeFolder);
		  	
		  	//post create will try to load the top level node.
		  	//we should open a progress bar to indicate that the widget is being intialized.
			org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator.superclass.postCreate.apply(this, arguments);
		},
		createProgress:function(){
			//summary: creates the progress node
			if (this.progressDescription != null){
				this.progressNode = document.createElement('div');
				var progressText = document.createElement('span');
				progressText.setAttribute("style", "padding-left:5px");
				progressText.appendChild(document.createTextNode(this.progressDescription));
				var img = document.createElement('img');
				img.setAttribute("src", this.rollerImagePath);
				this.progressNode.appendChild(img);
				this.progressNode.appendChild(progressText);
				this.domNode.appendChild(this.progressNode);
			}
			
		},
		markProcessing: function(){
			//summary: this function is called before loading the model into the tree.  The progress indicator is created.
			//bring up progress bar to indicate that the tree is being loaded
			this.createProgress();
			this.inherited("markProcessing", arguments);
		},
		unmarkProcessing: function(){
			//summary: this function is called after loading the model into the tree.  The progress indicator is destroyed.
			this.inherited("unmarkProcessing", arguments);
			this.destroyProgress();
		},
		destroyProgress: function(keyArgs){
			//summary: destroys the progress indicator node.
			if (this.progressNode){
				this.domNode.removeChild(this.progressNode);
			}
		},		
		addTreeNode:function(/*dojo.data.Item[]*/newItem, /*dojo.data.Item*/parent, /*boolean*/expand){
			// summary: Adds an item to the tree.  
			// description: This method takes in a list of items that will be added to a parent item.  
			//              The newItem contains an array of items that will be added to the item defined by the parent parameter.
			//              If the expand parameter is set to true the parent item will be expanded other the parent item will be collapsed.
			if (typeof(expand) == 'undefined'){
				expand = false;
			}
			if (typeof(parent) == 'undefined')
				parent = this.treeNode.item;
			try{
				if (dojo.isArray(newItem)) {
					for (var x=0; x < newItem.length; x++){
						this.addTreeNode(newItem[x], parent);			   
					}
				}
				else{
					var childObject = this.store.newItem(newItem, {parent:parent,attribute:'children'});
					childObject.parentItem = parent;
					//expand parent node	
					if (expand){
						var parentNode = this._itemNodeMap[this.store.getIdentity(parent)];
						this._expandNode(parentNode);
						var childNode = this._itemNodeMap[this.store.getIdentity(childObject)];
						if (childNode){
							this._publish("execute", { item: childNode.item, node: childNode} );
							this.onClick(childNode.item, childNode);
							this.blurNode();
							this.focusNode(childNode);
						}
					}
					return childObject;
					
				}
			}catch(e){
				console.debug(e);
				this.UIContext.log.logError(e);
			}
		},			
		deleteTreeNode:function(treeNode){
		// summary:
		//		Remove a node from the tree.
			if ((treeNode) && (treeNode.parentItem) &&(treeNode.parentItem.children)){
				var index = dojo.indexOf(treeNode.parentItem.children, treeNode);
				if (index != -1){
					treeNode.parentItem.children.splice(index, 1);
				}
			}
			this.store.deleteItem(treeNode);
		},		
		getItemChildren: function(parentItem, onComplete){
			// summary
			// 		User overridable function that return array of child items of given parent item,
			//		or if parentItem==null then return top items in tree
			var store = this.store;
			if(parentItem == null){
				// get top level nodes
				store.fetch({ query: this.query, onComplete: onComplete});
			}else{
				// get children of specified node
				var childItems = [];
				var self = this;
				function setChildrenArray(children){
					childItems= childItems.concat(children);
					// count how many items need to be loaded
					var _waitCount = 0;
					dojo.forEach(childItems, function(item){ if(!store.isItemLoaded(item)){ _waitCount++; } });
					if(_waitCount == 0){
						// all items are already loaded.  proceed..
						onComplete(childItems);
					}else{
						// still waiting for some or all of the items to load
						function onItem(item){
							if(--_waitCount == 0){
								// all nodes have been loaded, send them to the tree
								onComplete(childItems);
							}
						}
						dojo.forEach(childItems, function(item){
							if(!store.isItemLoaded(item)){
								store.loadItem({item: item, onItem: onItem});
							}
						});
					}
				}
				
				//only support 1 child attribute
				store.getValues(parentItem, this.childrenAttr[0], setChildrenArray);				
			}
		}
	}
	
);	

dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.widget.NewNodeMenu",
	// superclass	
	null,
	{
		constructor: function(params){
			dojo.mixin(this,params);
		},
		widgetClass:'cosmos:QueryMenu',
		cmdbfQuery:null,
		createContextMenu: function(menu, store, className){
			//check for specific node class
			this.populateMenu(menu, store, className);
		},
		populateMenu:function(menu, store, className){
			var queryEPR = this.UIContext.getService(store.item, "http://cmdbf.org/schema/1-0-0/query");
			if (queryEPR == null) return;
			var self = this;
			menu.addChild(new dijit.MenuItem({item:this,UIContext:this.UIContext, store:store, sourceObject: this.sourceObject,onClick:function(){
				var sourceObject = this.sourceObject; 
				var store = this.store;
		    	var queryObject = this.UIContext.createObject(self.query);
		    	queryObject.bindInput(store.item, function(item){
					sourceObject.addQueryTreeNode(item, store.item, true);
				});
			},
			label:this.label
			}));
		}
	}
);

dojo.declare(
		   "org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryMenu",
			// superclass
			null,
			{
				constructor: function(params){
					dojo.mixin(this,params);
				},
				widgetClass:'cosmos:QueryMenu',
				cmdbfQuery:null,
				createContextMenu:function(menu, store, className){
					var self = this;
					menu.addChild(new dijit.MenuItem({item:this,UIContext:this.UIContext, store:store, sourceObject: this.sourceObject,onClick:function(){
						var sourceObject = this.sourceObject; 
						var store = this.store;
				    	var queryObject = this.UIContext.createObject(self.query);
						this.UIContext.submitQuery({queryObject:queryObject, item:store.item, onItem:function(items){
							sourceObject.addTreeNode(items.items, store.item, true);
							}, queryProp:"query"});
					},
					label:this.label
					}));
				}
			}
		);

dojo.declare(
		// class
		"org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryNavigator",

		// superclass	
		[org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator],
		
		// member variables/functions
		{
			queriesHandler:"json?service=org/eclipse/cosmos/internal/dr/drs/service/handler/common/QueriesOutputter",
			cmdbfQueryHandler:"json?service=org/eclipse/cosmos/internal/dr/drs/service/outputter/CMDBfQuery",
			unmarkProcessing: function(){
				this.inherited("unmarkProcessing", arguments);
				//now we should add query nodes to the tree.
				this.addQueryNodes(null);
			},
		    getCMDBfResponse:function(args){
				var item = args.item;
		    	if (item.queryResponse){
		    		args.onItem(item.queryResponse);
		    		return item.queryResponse;
		    	}
				//check if this is a query node.
				if (item.query){
					//always submit a response?
					var queryEPR = this.UIContext.getService(item, "http://cmdbf.org/schema/1-0-0/query");
					if (queryEPR == null)
						queryEPR = item.epr[0];
					if (queryEPR != null){
						this.UIContext.submitQuery({
										queryObject: new org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery(
												{
												 queryHandler:this.cmdbfQueryHandler, 
												 postData:"query="+escape(item.query)+"&epr="+escape(queryEPR)
												}), 
									     onItem:function(response){
												item.queryResponse = response;
												if (args.onItem)
													args.onItem(response);
										 }, 
									     queryProp:"query"
									    });
					}
				}					
		    },
		    addQueryTreeNode:function(/*dojo.data.Item[]*/newItem, /*dojo.data.Item*/parent, /*boolean*/expand){
		    	newItem.getResponse = function(args){};
		    	dojo.connect(newItem, "getResponse", this, "getCMDBfResponse");
		    	this.addTreeNode(newItem, parent, expand);
		    },
		    treeHandler: function(/*Object*/message){
				//summary: This method is called when the user selects a nodes
				//description: The message parameter contains the node that was selected.  The message parameter is cloned and published to 
				//  topics specified by the the publish memeber variable of this class.
		    	var _self = this;
		    	var _arg = arguments;
		    	if ((message.node.item) && (!message.node.item.queryResponse) && (message.node.item.getResponse)){
		    		message.node.item.getResponse[0]({item:message.node.item,onItem:function(response){
		    			_self.inherited(_arg);		    			
		    		}
		    		});
		    	}
		    	else{
		    		this.inherited(arguments);
		    	}
		    },		    
			addQueryNodes: function(parentItem){
				var _self = this;
				this.getItemChildren(parentItem, function(items){
					var classList = {}; 
						for (i=0;i < items.length;i++){
							if (!(classList[items[i].nodeClass])){
								classList[items[i].nodeClass] = items[i].nodeClass;
							}
						}
						var classStrings = "";
						for(nodeClassStr in classList) {  
							classStrings = classStrings+nodeClassStr+",";
						}
					var addQueries = function(response){
						for (i=0;i < items.length;i++){
							if (response[items[i].nodeClass]){
								var nodeObjs = response[items[i].nodeClass];
								for (j=0;j < nodeObjs.length;j++){
									var nodeObj = new Object();
							 	    dojo.mixin(nodeObj,nodeObjs[j].meta);
									
									if ( nodeObjs[j].query)
										nodeObj.query = nodeObjs[j].query;
										//make node unique
										nodeObj.object = dojo.dnd.getUniqueId();
	
										//determine if we need to inherit attributes from parent
										var parent = items[i];
										for(attribute in nodeObj) {  
											if (nodeObj[attribute] == "__inherit__"){
												if (parent[attribute])
													nodeObj[attribute] = parent[attribute];
											}
											//treat query and title as special attributes that we have to process
										}
										for(attribute in nodeObj) { 
											if ((attribute=="title") || (attribute=="query")){
												nodeObj[attribute] = dojo.string.substitute(nodeObj[attribute], nodeObj); 							
											}
										}
									
									_self.addQueryTreeNode(nodeObj, items[i], false);
									var childNode = _self._itemNodeMap[_self.store.getIdentity(items[i])];
									childNode.childDoneLoading = function(){
										_self.addQueryNodes(this.item);
									}
								}
								dojo.connect(childNode, "unmarkProcessing", childNode, "childDoneLoading");
							}
						}
					}
					_self.UIContext.submitRequest({url:_self.queriesHandler+"&nodeClass="+classStrings, postData:"", onItem: addQueries});
				});					
			}
			
			
		}
);
dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.widget.RemoveMenu",
	// superclass	
	org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryMenu,
	{
		widgetClass:'cosmos:RemoveMenu',
		createContextMenu: function(menu, store, className){
			this.inherited(arguments);
		},
		populateMenu:function(menu, store, className){
			menu.addChild(new dijit.MenuItem({onClick:function(){
				store.tree.deleteTreeNode(store.item);
			},
			label:this.label
			}));
		}
	}
); 
dojo.declare
(
	 "org.eclipse.cosmos.provisional.dr.ps.components.widget.ViewMenu",
        // superclass
	 null,
  {
    constructor: function(params){
			dojo.mixin(this,params);
	},
    widgetClass:'cosmos:ViewMenu',
    createContextMenu: function(menu, store, className)
    {
	  var metaEPR = this.UIContext.getService(store.item, "http://cmdbf.org/schema/1-0-0/query");
	  if (metaEPR == null) return;
	  var _self = this;
      menu.addChild(new dijit.MenuItem(
      { onClick:
        function()
        {
          if (typeof(_self.publish) != 'undefined')
          {
             //clone item since we don't want to modify the original item
             var contextMap = store.item;
             contextMap.contentNode = _self.url + "&mdr="+escape(metaEPR);
             for (y=0;y < _self.publish.length;y++)
               	 dojo.publish(_self.publish[y], [{contextMap:contextMap}]);
          }
        },
		label:this.label
      }
      ));
    }
  }
);


