/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
if(!dojo._hasResource["org.eclipse.cosmos.provisional.dr.ps.components.data.WidgetStore"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["org.eclipse.cosmos.provisional.dr.ps.components.data.WidgetStore"] = true;
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.data.WidgetStore");


dojo.declare("org.eclipse.cosmos.provisional.dr.ps.components.data.WidgetStore", null , {
	logger: null,
	widgetService: "json?service=org/eclipse/cosmos/internal/dr/drs/service/outputter/widget/WidgetProperties",
	initialize: function( keywordArgs){
		if (djConfig.cosmosWidgetService)
			this.widgetService = djConfig.cosmosWidgetService;
		this.logger = new org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorHandler();
		//need to initialize store
		// Callback for handling a successful load.
		var self = this;
		var gotData = function(data){
			//check if an error was recieved
			if (data._error_){	
				//need to decode string messages
				var detail = unescape(data.detail);
				var message = unescape(data.message);
				rExp = /\+/gi;
				data.detail=detail.replace(rExp, " ");				
				data.message=message.replace(rExp, " ");
				self.logger.logError(data,true);					
				if(keywordArgs.onError){
						var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
						keywordArgs.onError.call(scope, data);
				}
				 
			}
			else{
				self.tagLookup = data;
				//Done processing!  Call the onItem, if any.
				if(keywordArgs.onInit){
					var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
					keywordArgs.onInit.call(scope, data);
				}
			}
		};
	
		//Callback for any errors that occur during load.
		var gotError = function(error){
			//Call the onComplete, if any
			if(keywordArgs.onError){
				var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
				keywordArgs.onError.call(scope, error);
			}
		};
	
		//Fire the get and pass the proper callbacks to the deferred.
		var xhrArgs = {
			url: this.widgetService+"&func=getTags",
			handleAs: "json"
		};
		
		var d = dojo.xhrGet(xhrArgs);
		d.addCallback(gotData);
		d.addErrback(gotError);	
	
	},		
	tagLookup: [],
	widgetMap: {},
	getWidgetProperties: function(keywordArgs) {
		//search array for tag
		var found = false;
		var tag = keywordArgs.tags;
		if (dojo.isArray(keywordArgs.tags)){
			for (var y=0; y < keywordArgs.tags.length; y++){
				for (var x=0; x < this.tagLookup.length; x++){
					if (this.tagLookup[x] == keywordArgs.tags[y]){
						tag = keywordArgs.tags[y];
						found = true;
						break;
					}
				}
				if (found)
					break;
			}
		}
		else{
			for (var x=0; x < this.tagLookup.length; x++){
				if (this.tagLookup[x] == keywordArgs.tags){
					found = true;
					break;
				}
			}
		}

		if (found){
			if ((this.widgetMap == null) || (this.widgetMap[tag] == null) || (typeof(this.widgetMap[tag]) == 'undefined')){
				var self = this;
				this.loadProperties({tag:tag, onItem:function(data){
					self.widgetMap[tag]=data;
					var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
					keywordArgs.onItem.call(scope, data);
				}});
			}
			else{
					var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
					keywordArgs.onItem.call(scope, this.widgetMap[tag]);
			}
		}
	},
		
	loadProperties: function(keywordArgs){
		var self = this;
		// Callback for handling a successful load.
		var gotData = function(data){
				//check if an error was recieved
				if (data._error_){	
					//need to decode string messages
					var detail = unescape(data.detail);
					var message = unescape(data.message);
					rExp = /\+/gi;
					data.detail=detail.replace(rExp, " ");				
					data.message=message.replace(rExp, " ");
					self.logger.logError(data,true);					
					if(keywordArgs.onError){
							var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
							keywordArgs.onError.call(scope, data);
					}
					 
				}
				else{
					//Done processing!  Call the onItem, if any.
					if(keywordArgs.onItem){
						var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
						keywordArgs.onItem.call(scope, data);
					}
				}
		};

		//Callback for any errors that occur during load.
		var gotError = function(error){
			//Call the onComplete, if any
			if(keywordArgs.onError){
				var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
				keywordArgs.onError.call(scope, error);
			}
		};

		//Fire the get and pass the proper callbacks to the deferred.
		var xhrArgs = {
			url: this.widgetService+"&tag="+keywordArgs.tag,
			handleAs: "json"
		};
		
		var d = dojo.xhrGet(xhrArgs);
		d.addCallback(gotData);
		d.addErrback(gotError);
	}
});


}
