/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.utility.common");
dojo.require("dijit.Dialog");
dojo.require("dijit.TitlePane");
dojo.require("dijit.form.Button");
dojo.require("dijit.form.TextBox");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.data.WidgetStore");
dojo.requireLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "utility");
dojo.declare(
		"org.eclipse.cosmos.provisional.dr.ps.components.utility.UIContext",
		null,
		{
			_message: dojo.i18n.getLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "utility"),
			started:false,
			localeObj: null,
			idCounter:0,
			namespace:"_C_O",
			constructor: function(params){
				dojo.mixin(this,params);
			 	this.initialize();
			 	dojo.subscribe("org.eclipse.cosmos.provisional.dr.ps.components.utility.UIContext", this, this.setUIContext);			 	
			},
			initialize:function(){
				var self = this;	
				this.widgetStore = new org.eclipse.cosmos.provisional.dr.ps.components.data.WidgetStore();
				this.widgetStore.initialize({onInit:function(){
			   		self.getStyleProperties("_cosmos_context_", function(data){
						if ((data) && (data.view)){
							if (data.view.errorHandler){
								self.log = self.createObject(data.view.errorHandler);
								self.log._context = self;
							}
							if (data.view.localeHandler){
								self.localeObj = self.createObject(data.view.localeHandler);
							}
						}
						if (!self.log){
							self.log = new org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorHandler();
							self.log._context = self;
						}
						if (!self.localeObj)
							self.localeObj = new org.eclipse.cosmos.provisional.dr.ps.components.utility.Localization();
						self.widgetStore.logger.destroy();
						self.widgetStore.logger = self.log;
						dojo.publish("initializeWidget", [{context:self}]);
					 	self.started = true;
				   		}
			   		);
				}});
			},
			setUIContext: function(obj){
			  		if (obj)
			   			obj.setUIContext(this);
			},			
			getString: function(bundle, key){
				this.localeObj.getString(bundle, key);
			},
			getStyleProperties :function(tag, onItem){		
				this.widgetStore.getWidgetProperties({tags:tag, onItem:onItem});
			},	
			createObject :function(prop, cell){       		
				//create widget		
				var properties = dojo.clone(prop);
		
				properties.UIContext = this;
				if (properties.clazz){
					return eval("new "+properties.clazz+"(properties, cell)");
				}
				return null;
			
			},
			createWidgetView :function(tag, parentWidget, widgetCallback, cell, contextMap){
				var self = this;
		   		this.getStyleProperties(tag, function(data){
		   			var style = dojo.clone(data);
		   			if ((style) && (style.view)){   				
		   				
			   			style.view.parentWidget = parentWidget;
			   			
			   			var widgetProperties = style.view;
						widgetProperties.UIContext = self;
						if (dojo.isArray(tag)){
							widgetProperties.attachPoint = tag[tag.length-1];
						}
						else{
							widgetProperties.attachPoint = tag;
						}
						widgetProperties.contextMap = contextMap;
						widgetProperties.dataMap = style.dataMap;
						console.debug(widgetProperties);
						var viewObject = dojo.getObject(widgetProperties.clazz);
						console.debug(viewObject);
						if (dojo.isFunction(viewObject)){
							//need to see if we already created the object
							var oldWidget = dijit.byId(widgetProperties.id);
							if (oldWidget)
								oldWidget.destroy();
							//We need to see if this is a pure function or an object constructor...
							if (!widgetProperties.id){
								widgetProperties.id = self.namespace+self.idCounter;
								if (!widgetProperties.widgetId){
									widgetProperties.widgetId = widgetProperties.id;
								}
								self.idCounter++;
							}
							
							var widget = new viewObject(widgetProperties, cell);
						//call callback to with widget			
							if (widgetCallback)
								widgetCallback(widget);
							return true;
						}
					}
					return false;
		   		});
				
			},	
			getService:function(data, namespace){
				if (data.services){
					var t = data.services[0];
					for (var y=0; y < data.services.length; y++){
						var service= data.services[y];
						if (service[0]==namespace){
							return service[1];
						}
					}
				}
				return null;
			},
			submitRequest:function(keyArgs){
					var deferred = dojo.rawXhrPost({
				        url: keyArgs.url,
						handleAs: "json-comment-optional",
				        postData: keyArgs.postData,
				        onItem: keyArgs.onItem,
				        handle: function(response, ioArgs){
				                //This function handles the response.
				                //Inside this function, the "this" variable
				                //will be the object used as the argument to the dojo.xhrGet() call.
								if(response instanceof Error){
				                        if(response.dojoType == "cancel"){
				                                //The request was canceled by some other JavaScript code.						                        	   
				                        		if (log) _self.log.logInfo (dojo.string.substitute(_self._message.REQUEST_CANCEL, [_self.url, response]));
				                        }else if(response.dojoType == "timeout"){
				                                //The request took over 5 seconds to complete.
			                        		if (log) _self.log.logInfo (dojo.string.substitute(_self._message.REQUEST_TIMEOUT, [_self.url, response]));
				                        }else{
				                                //Some other error happened.
			                        		if (log) _self.log.logInfo (dojo.string.substitute(_self._message.REQUEST_ERROR, [_self.url, response]));
				                        }
				                }
								else if (response._error_){	
									//need to decode string messages
									var detail = unescape(response.detail);
									var message = unescape(response.message);
									rExp = /\+/gi;
									response.detail=detail.replace(rExp, " ");				
									response.message=message.replace(rExp, " ");
									if (log)
										_self.log.logError(response,true);					
									if(keyArgs.onError){
											var scope = keyArgs.scope ? keyArgs.scope : dojo.global;
											keyArgs.onError.call(scope, response);
									}
									 
								}
	                        	this.onItem(response);
				                //If you think there could be other callback handlers registered with this deferred, then
				                //return response to propagate the same response to other callback handlers. Otherwise,
				                //the error callbacks may be called in the success case.
				                return response;
				        }
				});							
			},
			submitQuery:function(keyArgs){
				var item = keyArgs.item;
				var query = keyArgs.queryObject;
				var success = false;
				var log = true;
				var _self = this;
				if (keyArgs.log == false)
					log = keyArgs.log;
				if (typeof(query["queryHandler"]) != 'undefined'){
					//map input item to parameters of the query
					var postData = "";
						if (query.bindInput){
							success = query.bindInput(item, function(postData){
								//IE doesn't allow json object as post Data
								if (!(dojo.isString(postData)))
									postData = "";
								var deferred = dojo.rawXhrPost({
								        url: query["queryHandler"],
										handleAs: "json-comment-optional",
								        postData: postData,
								        queryObject: query,        
								        onItem: keyArgs.onItem,
								        handle: function(response, ioArgs){
								                //This function handles the response.
								                //Inside this function, the "this" variable
								                //will be the object used as the argument to the dojo.xhrGet() call.
												if(response instanceof Error){
								                        if(response.dojoType == "cancel"){
								                                //The request was canceled by some other JavaScript code.						                        	   
								                        		if (log) _self.log.logInfo (dojo.string.substitute(_self._message.REQUEST_CANCEL, [_self.url, response]));
								                        }else if(response.dojoType == "timeout"){
								                                //The request took over 5 seconds to complete.
							                        		if (log) _self.log.logInfo (dojo.string.substitute(_self._message.REQUEST_TIMEOUT, [_self.url, response]));
								                        }else{
								                                //Some other error happened.
							                        		if (log) _self.log.logInfo (dojo.string.substitute(_self._message.REQUEST_ERROR, [_self.url, response]));
								                        }
								                }
												else if (response._error_){	
													//need to decode string messages
													var detail = unescape(response.detail);
													var message = unescape(response.message);
													rExp = /\+/gi;
													response.detail=detail.replace(rExp, " ");				
													response.message=message.replace(rExp, " ");
													if (log)
														_self.log.logError(response,true);					
													if(keyArgs.onError){
															var scope = keyArgs.scope ? keyArgs.scope : dojo.global;
															keyArgs.onError.call(scope, response);
													}
													 
												}
												else{				
								                	//should only store the record contents so that we don't load the full graph response when loading the record viewer
								                	//check to see if we have to transform the response before sending the data to the call back method
								                	if ((this.queryObject) && (typeof(this.queryObject.render) != 'undefined')){
							                        	this.onItem(this.queryObject.render(response));
						                        	}
								                	else{
							                        	this.onItem(response);
						                        	}
								                }
							                	if ((this.queryObject) && (typeof(this.queryObject.onComplete) != 'undefined')){
							                		this.queryObject.onComplete(response)
							                	}
								                //If you think there could be other callback handlers registered with this deferred, then
								                //return response to propagate the same response to other callback handlers. Otherwise,
								                //the error callbacks may be called in the success case.
								                return response;
								        }
								});							
								
							
							});
						}
					}
				return success;
			}
});




//This demonstrates a query unit   
dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery",
	// superclass	
	null,
	{
		queryHandler: null,
		postData: "",
		constructor: function(params){
			dojo.mixin(this,params);
		},
		bindInput: function(data, callbackMethod){		
				callbackMethod(this.postData);
		},
		render: function(input){
			return input;
		},
		onComplete: function(input){
		}		
		}
); 

//This demonstrates a query unit   
dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.utility.Localization",
	// superclass	
	null,
	{
			constructor: function(params){
				dojo.mixin(this,params);
			},
			getString: function(bundle, key){
				if (bundle.key)
					return bundle.key;
				return key;
			}
		}
); 

//Tree node query unit   
dojo.declare(
"org.eclipse.cosmos.provisional.dr.ps.components.utility.TreeNodeQuery",
	// superclass	
	null,
	{
		queryHandler: null,
		namespace:null,
		constructor: function(params){
			dojo.mixin(this,params);
		},
		bindInput: function(data, callbackMethod){
			var epr = data.epr;
			if ((this.namespace != null) && (data)){
				epr = this.UIContext.getService(data, this.namespace);
				if (epr == null)
					epr = data.epr;
			}
			
				callbackMethod("title="+data.title+"&epr="+escape(epr));
		},
		render: function(input){
			return input;
		}
	}
); 


//Tree node property query unit   
dojo.declare(
"org.eclipse.cosmos.provisional.dr.ps.components.utility.TreeNodePropertyQuery",
	// superclass	
	null,
	{
		queryHandler: null,
		constructor: function(params){
			dojo.mixin(this,params);
		},
		bindInput: function(data, callbackMethod){
				callbackMethod("title="+data.title+"&epr="+escape(data.epr)+"&prop=true");
		},
		render: function(input){
			return input;
		}
	}
); 


//Tree node CMDBf   
dojo.declare(
"org.eclipse.cosmos.provisional.dr.ps.components.utility.TreeNodeCMDBf",
	// superclass	
	null,
	{
		queryHandler: null,
		constructor: function(params){
			dojo.mixin(this,params);
		},
		bindInput: function(data, callbackMethod){
			if (data.object != null){
				callbackMethod("title="+data.title+"&epr="+escape(data.epr)+"&object="+data.object);
			}
		},
		render: function(input){
			return input;
		}
	}
); 


dojo.declare(
		   "org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorQuery",
			// superclass	
		   org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery,
			{
				queryHandler:"json?service=org/eclipse/cosmos/provisional/dr/drs/service/ErrorLogger",
				bindInput: function(data, callbackMethod){
			   		callbackMethod("message="+data.message+"&detail="+data.detail+"&sev="+data.severity);
				},
				render: function(input){
					return input;
				}
			}
		); 


dojo.declare(
		"org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorDialog",
		[dijit._Widget, dijit._Templated, dijit._Container], 
		{
			_message: dojo.i18n.getLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "utility"),
		 	title:"",
			message:"",	 	
			icon:"",
			detail:"",
			templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.utility", "html/ErrorDialog.html"),
			widgetsInTemplate: true,
			widgetId: "errorDialog",
			show: function(){
				this.dialogBox.show();
			},
			onOk: function(){
				this.dialogBox.onCancel();
			},
			submitQuery: function(){
			},
			create: function(params, srcNodeRef) {
				//for some reason I need to destroy widget explicitly
	   			if (dijit.byId(this.widgetId) != null){
	   				dijit.byId(this.widgetId).destroy();
	   				dijit.byId(this.widgetId+"_ok").destroy();
	   			}
				this.okLbl=this._message.OK;
				org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorDialog.superclass.create.apply(this, arguments);
			},			
			postMixInProperties: function(){
				if (dojo.isObject(this.message)){
					if (this.message.title)
						this.title = this.message.title;
					if (this.message.detail)
						this.detail = this.message.detail;
					if (this.message.message)
						this.message = this.message.message;
				}
				//call superclass
				org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorDialog.superclass.postMixInProperties.apply(this, arguments);
			},
			postCreate: function(){
				//call superclass
				org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorDialog.superclass.postCreate.apply(this, arguments);
				this.dialogBox = dijit.byId(this.widgetId);
				//focus on the ok button
				dijit.byId(this.widgetId+"_ok").focus();
			},
			destroy: function(){
				//call superclass
				org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorDialog.superclass.destroy.apply(this, arguments);
				if (this.dialogBox){
					this.dialogBox.onCancel();
				}
				dijit.byId(this.widgetId+"_ok").destroy();
				this.inherited(arguments);
			}
			
			
		}
	);   
dojo.declare(
		"org.eclipse.cosmos.provisional.dr.ps.components.utility.ProgressDialog",
		[dijit._Widget, dijit._Templated, dijit._Container], 
		{
		 	title:"",
			message:"",	 	
			icon:"",
			detail:"",
			rollerImagePath:dojo.moduleUrl("dojox","off/resources/roller.gif").uri,			
			templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.utility", "html/ProgressDialog.html"),
			widgetsInTemplate: true,
			widgetId: "progressDialog",
			show: function(){
				this.dialogBox.show();
			},
			onCancel: function(){
				this.dialogBox.onCancel();
			},
			create: function(params, srcNodeRef) {
				//for some reason I need to destroy widget explicitly
	   			if (dijit.byId(this.widgetId) != null){
	   				dijit.byId(this.widgetId).destroy();
	   			}
				org.eclipse.cosmos.provisional.dr.ps.components.utility.ProgressDialog.superclass.create.apply(this, arguments);
			},			
			postCreate: function(){
				//call superclass
				org.eclipse.cosmos.provisional.dr.ps.components.utility.ProgressDialog.superclass.postCreate.apply(this, arguments);
				this.dialogBox = dijit.byId(this.widgetId);
			},
			destroy: function(){
				this.dialogBox.onCancel();
				//call superclass
				org.eclipse.cosmos.provisional.dr.ps.components.utility.ProgressDialog.superclass.destroy.apply(this, arguments);
			}
		}
	);   

dojo.declare(
		"org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorHandler",
		null,
		{
	 	serverHandler:null,
	 	serverQuery:null,
	 	_context:null,
		//defines a url that will recieve logged messages.
	 	ERROR:1,
	 	INFO:2,
	 	WARNING:4,
	 	NONE:0,
		//atribute that determins if the message should be logged to the dojo debug console.
	 	debug:7,
		//defines the dialog box that will show the message.
		promptDialog:null,
		//attribute that determines if a dialog box should be displayed when a message is logged
		prompt:false,
		persist:0,
		logTopic: null,
		constructor: function(params){
			dojo.mixin(this,params);
			this.logTopic = dojo.subscribe("org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorHandler", this, this.log);
		},
		destroy:function() {
			dojo.unsubscribe(this.logTopic);
		},
		log:function(keywordArgs) {
			if ((keywordArgs) && (keywordArgs.message)){
				var argPrompt = false;
				if (keywordArgs.prompt)
					argPrompt = true;
				if (keywordArgs.severity==this.ERROR){
					this.logError(keywordArgs.message,argPrompt);
				}
				else if (keywordArgs.severity==this.WARNING){
					this.logWarning(keywordArgs.message,argPrompt);
				}
				else{
					this.logInfo(keywordArgs.message,argPrompt);
				}
					
			}
		},
		logError:function(message, prompt) {
		// summary: logs an error messages
		// description: the message is logged as an error message.  If the prompt argument
	 	//    is set to true a dialog message is presented to the user.
			if (this.debug & this.ERROR)
				console.error(message);
			if ((prompt) || (this.promptDialog & this.ERROR)){
				this.dialog = new org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorDialog({icon:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.utility", "html/images/error.gif"),title:"Error",message:message});
				this.dialog.show();
			}
			if (this.persist & this.ERROR){
				this.submitQuery(this.ERROR, message);
			}
		},
		logWarning:function(message, prompt) {
		// summary: logs a warning messages
		// description: the message is logged as a warning message.  If the prompt argument
	 	//    is set to true a dialog message is presented to the user.
			if (this.debug & this.WARNING)
				console.debug(message);
			if ((prompt) || (this.promptDialog & this.WARNING)){
				this.dialog = new org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorDialog({icon:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.utility", "html/images/warning.gif"),title:"Warning",message:message});
				this.dialog.show();
			}
			if (this.persist & this.WARNING){
				this.submitQuery(this.WARNING,message);
			}
		},
		logInfo:function(message, prompt) {
		// summary: logs an informational messages
		// description: the message is logged as an informational message.  If the prompt argument
	 	//    is set to true a dialog message is presented to the user.
			if (this.debug & this.INFO)
				console.debug(message);
			if ((prompt) || (this.promptDialog & this.INFO)){
				this.dialog = new org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorDialog({icon:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.utility", "html/images/inform.gif"),title:"Information",message:message});
				this.dialog.show();
			}
			if (this.persist & this.INFO){
				this.submitQuery(this.INFO, message);
			}
		},
		submitQuery:function(severity, message, detail){
			if (this._context != null){
				if (this.serverQuery == null)
					this.serverQuery = new org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorQuery();
				if (this.serverHandler != null)
					this.serverQuery.queryHandler= this.serverHandler;
				this._context.submitQuery({queryObject:this.serverQuery, item:{message:message, detail:detail, severity:severity}, log:false, onItem:function(data){
					//do we need to log data received from data feed?
				}});
			}
		}
});

dojo.addOnLoad(
	function(e) {
		new org.eclipse.cosmos.provisional.dr.ps.components.utility.UIContext();
	}
);
