/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.Layouts");
dojo.require("dojox.layout.FloatingPane");

dojo.declare("org.eclipse.cosmos.provisional.dr.ps.components.widget.FloatingLayout", 
	dojox.layout.FloatingPane,
{
	templateString:"<div class=\"dojoxFloatingPane\" id=\"${id}\">\n\t<div tabindex=\"0\" waiRole=\"button\" class=\"dojoxFloatingPaneTitle\" dojoAttachPoint=\"focusNode\">\n\t\t<span dojoAttachPoint=\"maximizeWindowNode\" dojoAttachEvent=\"onclick: maximizeWindow\" class=\"maximizeWinIcon\"></span>\n\t\t<span dojoAttachPoint=\"restoreWindowNode\" dojoAttachEvent=\"onclick: restoreWindow\" class=\"hideWindowIcon\"></span>\n\t\t<span dojoAttachPoint=\"closeNode\" dojoAttachEvent=\"onclick: close\" class=\"dojoxFloatingCloseIcon\"></span>\n\t\t<span dojoAttachPoint=\"maxNode\" dojoAttachEvent=\"onclick: maximize\" class=\"dojoxFloatingMaximizeIcon\"></span>\n\t\t<span dojoAttachPoint=\"restoreNode\" dojoAttachEvent=\"onclick: _restore\" class=\"dojoxFloatingRestoreIcon\"></span>\t\n\t\t<span dojoAttachPoint=\"dockNode\" dojoAttachEvent=\"onclick: minimize\" class=\"dojoxFloatingMinimizeIcon\"></span>\n\t\t<span dojoAttachPoint=\"titleNode\" class=\"dijitInline dijitTitleNode\"></span>\n\t</div>\n\t<div dojoAttachPoint=\"canvas\" class=\"dojoxFloatingPaneCanvas\">\n\t\t<div dojoAttachPoint=\"containerNode\" waiRole=\"region\" tabindex=\"-1\" class=\"${contentClass}\">\n\t\t</div>\n\t\t<span dojoAttachPoint=\"resizeHandle\" class=\"dojoxFloatingResizeHandle\"></span>\n\t</div>\n</div>\n",
	offsetWidth:0,
	offsetHeight:0,

	maximizeWindow: function(){
		var windows = dojo.filter(
			this._allFPs,
			function(i){
				return i !== this;
			}, 
		this);
		dojo.forEach(windows, function(w, x){
			w.minimize();
		}, this);
		dojo.removeClass(this.maximizeWindowNode,"maximizeWinIcon");
		dojo.addClass(this.maximizeWindowNode,"hideWindowIcon");
		dojo.removeClass(this.restoreWindowNode,"hideWindowIcon");
		dojo.addClass(this.restoreWindowNode,"restoreWinIcon");
		dojo.removeClass(this.dockNode,"dojoxFloatingMinimizeIcon");
		dojo.addClass(this.dockNode,"hideWindowIcon");
		this.domNode.style.position ="absolute"; 
		this.domNode.style.left = "0"; 
		this.domNode.style.top = "0"; 

		this.maximize();

	},
	restoreWindow:function (){
		if(this._maximized == false){ return; }
		this.domNode.style.position ="relative"; 
		this._restore();
		dojo.removeClass(this.maximizeWindowNode,"hideWindowIcon");
		dojo.addClass(this.maximizeWindowNode,"maximizeWinIcon");
		dojo.removeClass(this.dockNode,"hideWindowIcon");
		dojo.addClass(this.dockNode,"dojoxFloatingMinimizeIcon");
		dojo.removeClass(this.restoreWindowNode,"restoreWinIcon");
		dojo.addClass(this.restoreWindowNode,"hideWindowIcon");

		var windows = dojo.filter(
			this._allFPs,
			function(i){
				return i !== this;
			}, 
		this);
		dojo.forEach(windows, function(w, x){
			w.show();
		}, this);

	},
	maximize: function(){
		// summary: Make this floatingpane fullscreen (viewport)	
		if(this._maximized){ return; }
		this._naturalState = dojo.coords(this.domNode);
		if(this._isDocked){
			this.show();
			setTimeout(dojo.hitch(this,"maximize"),this.duration);
		}
		dojo.addClass(this.focusNode,"floatingPaneMaximized");
		var viewPort = dijit.getViewport();
		viewPort.w = viewPort.w-this.offsetWidth;
		viewPort.h = viewPort.h-this.offsetHeight;
		this.resize(viewPort);
		this._maximized = true;
	}
});