/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.common");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.Layouts");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.WidgetContainer");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.PropertiesContainer");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.Report");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryBuilder");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTree");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterPartialDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.GraphResponseViewer");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.DeRegisterDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.RecordDetailsDialog");
dojo.requireLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "utility");
dojo.requireLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "widget");

dojo.declare(
		'org.eclipse.cosmos.provisional.dr.ps.components.widget.HTMLContainer',
		[dijit._Widget, dijit._Templated, dijit._Container], 
		{
			// summary: This widget provides an iframe container to embed html content
			// description: This web component is used to embed html content from external systems. 
			//              For example, reports generated from a reporting system can be embedded 
			//              in this component. This allows an application to compose pages that are 
			//              made up of content from various external sources.
			//templatePath: String
			//   url path to the widget html template that describes this widget 
			templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/HTMLContainer.html"),
			// width: String
			//   specifies the width of the container
			width : "100%",
			// height: String
			//   specifies the height of the container
			height : "400",
			//content_provider: String
			//    url that contains the content that will be embedded in the iframe
			content_provider: "",
			//frameNode: Element
			//  element node that represents the iframe
			frameNode: null,
			//contentQuery: org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery
			//  a query object that provides the url used to update the content of the iframe 
			contentQuery:null,
			postCreate: function(){
				//summary: inherited diji._Widget method
				org.eclipse.cosmos.provisional.dr.ps.components.widget.HTMLContainer.superclass.postCreate.apply(this, arguments);
				this.resize();
				this.refreshContent(this.contextMap);
			},		
		    refreshContent:function(/*Object*/message) {
				//summary: This method will refresh the contents of the iframe based on the information stored in the message parameter.
				//description:  A XMLHttpRequest is made on the information stored in the queryObject.  The message parameter properties
				//              are passed to the query object.  The response returned from the XMLHttpRequest contains the url that is used
				//              as the content of the iframe
				var self = this;
				//make REST call to get content data
				if ((typeof(this.contentQuery) != 'undefined') && (this.contentQuery != null)){
			    	var queryObject = this.UIContext.createObject(this.contentQuery);
					if (!(this.UIContext.submitQuery({queryObject:queryObject, item:message, onItem:function(response){
							self.changeit(response);						 												
							}, queryProp:"query"}))){					
					//reset page
						this.changeit(this.blankPath);
					}
				}
				else if (message.contentNode){
					this.changeit(message.contentNode);
				}
		    },
			changeit:function(/*String*/url){
		    	//summary: This method will change the content of the iframe based on the url passed in
	  			this.frameNode.src=url;
			},
			resize:function(){
				//summary: updates the content of the iframe based on a resize change
				if(!this.domNode.parentNode){
					return;
				}
				var h = dojo._getContentBox(this.domNode.parentNode).h;
				this.frameNode.style.height = (h-10) + 'px';

			},
			// blankPath:String
			//    Url path to a blank html page.  This page is used if no url is specified
			blankPath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/blank.html")
		}
); 