/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.artifacts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementModel
extends ElementLocation {
    private String source;
    private String elementName;
    private int endingLine;
    private int endingColumn;
    private String additionalSchemaLocation;
    private List<String> calculatedValidationSchemas;
    private List<String> aliases;

    public ElementModel(String name, String filePath, int lineNumber, int columnNumber) {
        super(filePath, lineNumber, columnNumber);
        this.elementName = name;
        this.aliases = new ArrayList<String>();
    }

    public int getEndingLine() {
        return this.endingLine;
    }

    public void setEndingLine(int endingLine) {
        this.endingLine = endingLine;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String contents) {
        this.source = contents;
    }

    public String getElementName() {
        return this.elementName;
    }

    public int getEndingColumn() {
        return this.endingColumn;
    }

    public void setEndingColumn(int columnNumber) {
        this.endingColumn = columnNumber;
    }

    public int numberOfLines() {
        if (this.getLineNumber() > this.getEndingLine()) {
            return 0;
        }
        return this.getEndingLine() - this.getLineNumber() + 1;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " <" + this.elementName + "> line=" + this.getLineNumber() + ", col=" + this.getColumnNumber();
    }

    public void setAdditionalSchemaLocation(String string) {
        this.additionalSchemaLocation = string;
    }

    public String getAdditionalSchemaLocation() {
        return this.additionalSchemaLocation;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ElementModel)) {
            return false;
        }
        ElementModel elementModel = (ElementModel)o;
        return this.elementName.equals(elementModel.getElementName()) && new Path(this.getFilePath()).equals((Object)new Path(elementModel.getFilePath())) && this.source.equals(elementModel.getSource());
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases.addAll(aliases);
    }

    public List<String> getCalculatedValidationSchemas() {
        return this.calculatedValidationSchemas;
    }

    public void setCalculatedValidationSchemas(List<String> calculatedValidationSchemas) {
        this.calculatedValidationSchemas = calculatedValidationSchemas;
    }
}

