/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ConstraintNode;
import org.eclipse.cosmos.rm.validation.internal.artifacts.IdentityConstraintStructure;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderUtil;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityConstraintDataBuilder
extends AbstractDataBuilder<IdentityConstraintStructure> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.IdentityConstraintDataBuilder";
    private IdentityConstraintStructure identityStruct = new IdentityConstraintStructure();
    private IdentityConstraint identityDecl;
    private boolean elementHit;
    private boolean annotationHit;
    private boolean appInfoHit;
    private LinkedList<Integer> documentNodeInx = new LinkedList();
    private boolean documentElementHit;
    private boolean dataElementHit;
    private List<String> currentAliases;
    private String currentAlias;
    private boolean aliasElementHit;
    private int currentInx;
    private int currentDepth = -1;
    private String currentURI;
    private String currentElementName;
    private int orphanInx = 0;
    private IdentityConstraintMap identityConstraintMap;
    private boolean referencedConstraint;

    public IdentityConstraintDataBuilder() {
        this.addEvent(1);
        this.identityConstraintMap = new IdentityConstraintMap();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        byte currentPhase = this.getCurrentPhase();
        switch (currentPhase) {
            case 1: {
                this.handleDefinitionStartElement(uri, localName, attributes);
                break;
            }
            case 16: {
                this.handleInstanceStartElement(uri, localName, attributes);
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        byte currentPhase = this.getCurrentPhase();
        switch (currentPhase) {
            case 1: {
                this.handleDefinitionCloseElement(uri, localName);
                break;
            }
            case 16: {
                this.handleInstanceCloseElement(uri, localName);
                break;
            }
        }
    }

    private boolean validField(String field) {
        return field != null && field.length() > 0;
    }

    private void handleDefinitionStartElement(String uri, String localName, Attributes attributes) {
        boolean constraintDefined;
        if ("http://www.w3.org/2001/XMLSchema".equals(uri)) {
            if (!this.elementHit && "element".equals(localName)) {
                this.elementHit = true;
                this.currentURI = this.getTargetNamespace();
                this.currentElementName = attributes.getValue("name");
                this.currentElementName = this.currentElementName == null ? attributes.getValue("http://www.w3.org/2001/XMLSchema", "name") : this.currentElementName;
                String substitutionGroup = attributes.getValue("substitutionGroup");
                ConstraintNode substitutionGroupNode = this.validField(substitutionGroup) ? this.retrieveElementDeclaration(substitutionGroup) : null;
                while (substitutionGroupNode != null) {
                    IdentityConstraint[] identityConstraints;
                    IdentityConstraint[] identityConstraintArray = identityConstraints = substitutionGroupNode == null ? null : this.identityStruct.retrieveConstraint(substitutionGroupNode.getUri(), substitutionGroupNode.getName());
                    if (identityConstraints != null) {
                        int i = 0;
                        while (i < identityConstraints.length) {
                            this.identityStruct.addDeclaration(this.currentURI, this.currentElementName, identityConstraints[i]);
                            ++i;
                        }
                    }
                    substitutionGroupNode = substitutionGroupNode.getSubstitutionGroup();
                }
            } else if (this.elementHit && "annotation".equals(localName)) {
                this.annotationHit = true;
            } else if (this.annotationHit && "appinfo".equals(localName)) {
                this.appInfoHit = true;
            }
            return;
        }
        boolean isKey = "key".equals(localName);
        boolean isKeyRef = !isKey && "keyref".equals(localName);
        boolean isUnique = !isKeyRef && !isKey && "unique".equals(localName);
        boolean bl = constraintDefined = isKey || isKeyRef || isUnique;
        if (this.appInfoHit && "http://www.w3.org/2008/03/sml".equals(uri)) {
            if (constraintDefined) {
                String name = this.retrieveAttribute(attributes, "http://www.w3.org/2008/03/sml", "name");
                String ref = this.retrieveAttribute(attributes, "http://www.w3.org/2008/03/sml", "ref");
                if (this.validField(ref)) {
                    if (this.validField(name)) {
                        this.getMessageOutputter().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(this.locator.getLineNumber(), SMLValidationMessages.identityInvalidNameAttribute));
                        return;
                    }
                    IdentityConstraint constraint = this.identityConstraintMap.get(ref);
                    if (constraint == null) {
                        this.getMessageOutputter().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(this.locator.getLineNumber(), NLS.bind((String)SMLValidationMessages.identityMissingConstraint, (Object)ref)));
                        return;
                    }
                    if (constraint.getType() != this.computeType(isKey, isKeyRef, isUnique)) {
                        this.getMessageOutputter().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(this.locator.getLineNumber(), NLS.bind((String)SMLValidationMessages.identityBadReferenceType, (Object)ref)));
                        return;
                    }
                    this.referencedConstraint = true;
                    this.identityDecl = constraint;
                } else {
                    if (!this.validField(name)) {
                        return;
                    }
                    this.identityDecl = new IdentityConstraint(name);
                    final Map clonedPrefixMap = (Map)((Hashtable)super.getPrefixMap()).clone();
                    this.identityDecl.setNamespaceContext(new NamespaceContext(){

                        @Override
                        public String getNamespaceURI(String prefix) {
                            String uri = (String)clonedPrefixMap.get(prefix);
                            return uri == null ? "" : uri;
                        }

                        @Override
                        public String getPrefix(String arg0) {
                            return null;
                        }

                        public Iterator<?> getPrefixes(String arg0) {
                            return null;
                        }
                    });
                    this.identityDecl.setType(this.computeType(isKey, isKeyRef, isUnique));
                    if (isKeyRef) {
                        this.identityDecl.setReference(this.retrieveAttribute(attributes, "http://www.w3.org/2008/03/sml", "refer"));
                    }
                }
            } else if (this.identityDecl != null) {
                if (this.referencedConstraint) {
                    this.getMessageOutputter().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(this.locator.getLineNumber(), SMLValidationMessages.identityInvalidElements));
                    this.identityDecl = null;
                    return;
                }
                if ("selector".equals(localName)) {
                    String selector = attributes.getValue("xpath");
                    selector = selector == null ? attributes.getValue("http://www.w3.org/2008/03/sml", "xpath") : selector;
                    this.identityDecl.setSelector(selector);
                } else if ("field".equals(localName)) {
                    String field = attributes.getValue("xpath");
                    field = field == null ? attributes.getValue("http://www.w3.org/2008/03/sml", "xpath") : field;
                    this.identityDecl.addField(field);
                }
            }
        } else if (constraintDefined) {
            this.getMessageOutputter().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createWarningMessage(this.locator.getLineNumber(), SMLValidationMessages.identityBadDeclaration));
        }
    }

    private ConstraintNode retrieveElementDeclaration(String qName) {
        String[] uriLocalName = this.getUriLocalName(qName);
        return DataBuilderUtil.retrieveElement(new QName(uriLocalName[0], uriLocalName[1]));
    }

    private byte computeType(boolean isKey, boolean isKeyRef, boolean isUnique) {
        return (byte)(isKey ? 0 : (isKeyRef ? 1 : 2));
    }

    private String retrieveAttribute(Attributes attributes, String uri, String localName) {
        String value = attributes.getValue(localName);
        return value == null ? attributes.getValue(uri, localName) : value;
    }

    private void handleDefinitionCloseElement(String uri, String localName) {
        if ("http://www.w3.org/2008/03/sml".equals(uri)) {
            if (this.appInfoHit && this.identityDecl != null) {
                boolean isKey = "key".equals(localName);
                boolean isKeyref = "keyref".equals(localName);
                boolean isUnique = "unique".equals(localName);
                if (isKey || isKeyref || isUnique) {
                    if (this.validField(this.identityDecl.getSelector()) && this.identityDecl.getFields().size() > 0) {
                        if (this.identityConstraintMap.get(this.identityDecl.getName()) != null) {
                            this.getMessageOutputter().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(this.locator.getLineNumber(), SMLValidationMessages.identityDuplicateName));
                        } else {
                            this.identityStruct.addDeclaration(this.currentURI, this.currentElementName, this.identityDecl);
                            this.identityConstraintMap.add(this.identityDecl);
                        }
                        this.referencedConstraint = false;
                    }
                    this.identityDecl = null;
                }
            } else if (this.appInfoHit && "appinfo".equals(localName)) {
                this.appInfoHit = false;
            } else if (this.annotationHit && "annotation".equals(localName)) {
                this.annotationHit = false;
            }
        } else if ("http://www.w3.org/2001/XMLSchema".equals(uri) && this.elementHit && "element".equals(localName)) {
            this.elementHit = false;
        }
    }

    private void handleInstanceStartElement(String uri, String localName, Attributes attributes) {
        block9: {
            block7: {
                block10: {
                    block8: {
                        if (!"http://www.w3.org/2008/03/sml-if".equals(uri)) break block7;
                        if (this.documentElementHit || !"document".equals(localName)) break block8;
                        this.documentElementHit = true;
                        if (this.currentAliases != null) {
                            this.currentAliases.clear();
                        }
                        break block9;
                    }
                    if (!this.documentElementHit || !"data".equals(localName)) break block10;
                    this.dataElementHit = true;
                    break block9;
                }
                if (!this.documentElementHit || !"alias".equals(localName)) break block9;
                this.aliasElementHit = true;
                break block9;
            }
            if (this.dataElementHit) {
                ++this.currentDepth;
                this.currentInx = this.documentNodeInx.size() - 1 < this.currentDepth ? 0 : this.documentNodeInx.get(this.currentDepth) + 1;
                this.documentNodeInx.add(new Integer(this.currentInx));
                if (this.identityStruct.isConstrained(uri, localName)) {
                    int[] primitiveIndices = new int[this.documentNodeInx.size()];
                    int i = 0;
                    while (i < primitiveIndices.length) {
                        primitiveIndices[i] = this.documentNodeInx.get(i);
                        ++i;
                    }
                    if (this.currentAliases == null || this.currentAliases.isEmpty()) {
                        this.identityStruct.addOrphanedConstrainedInstance(this.orphanInx++, primitiveIndices);
                    } else {
                        i = 0;
                        int aliasCount = this.currentAliases.size();
                        while (i < aliasCount) {
                            this.identityStruct.addConstrainedInstance(this.currentAliases.get(i), primitiveIndices);
                            ++i;
                        }
                    }
                }
            }
        }
    }

    private void handleInstanceCloseElement(String uri, String localName) {
        if ("http://www.w3.org/2008/03/sml-if".equals(uri)) {
            if (this.dataElementHit && "data".equals(localName)) {
                this.dataElementHit = false;
            } else if (this.documentElementHit && "document".equals(localName)) {
                this.documentElementHit = false;
                this.currentDepth = -1;
                this.documentNodeInx = new LinkedList();
            } else if (this.aliasElementHit && "alias".equals(localName)) {
                this.aliasElementHit = false;
                if (this.currentAlias != null) {
                    if (this.currentAliases == null) {
                        this.currentAliases = new ArrayList<String>();
                    }
                    this.currentAliases.add(this.currentAlias);
                }
                this.currentAlias = null;
            }
        } else if (this.dataElementHit) {
            --this.currentDepth;
            if (this.documentNodeInx.size() - this.currentDepth >= 3) {
                this.documentNodeInx.removeLast();
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.aliasElementHit) {
            this.currentAlias = this.currentAlias == null ? new String(ch, start, length) : String.valueOf(this.currentAlias) + new String(ch, start, length);
        }
    }

    @Override
    public IdentityConstraintStructure getDataStructure() {
        return this.identityStruct;
    }

    private String[] getUriLocalName(String name) {
        String[] stringArray;
        Map<String, String> prefixMap = this.getPrefixMap();
        String[] tokenizedName = name.split(":");
        if (tokenizedName.length == 2) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = prefixMap.get(tokenizedName[0]);
            stringArray = stringArray2;
            stringArray2[1] = tokenizedName[1];
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = this.getTargetNamespace();
            stringArray = stringArray3;
            stringArray3[1] = tokenizedName[0];
        }
        return stringArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IdentityConstraint {
        public static final byte KEY_TYPE = 0;
        public static final byte KEY_REF_TYPE = 1;
        public static final byte UNIQUE_TYPE = 2;
        private byte type;
        private String name;
        private List<String> fields;
        private String selector;
        private NamespaceContext namespaceContext;
        private String reference;

        public IdentityConstraint(String name) {
            this.name = name;
            this.fields = new ArrayList<String>();
        }

        public byte getType() {
            return this.type;
        }

        public void setType(byte type) {
            this.type = type;
        }

        public List<String> getFields() {
            return this.fields;
        }

        public String getSelector() {
            return this.selector;
        }

        public void setFields(List<String> fields) {
            this.fields = fields;
        }

        public void addField(String field) {
            this.fields.add(field);
        }

        public void setSelector(String selector) {
            this.selector = selector;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public NamespaceContext getNamespaceContext() {
            return this.namespaceContext;
        }

        public void setNamespaceContext(NamespaceContext namespaceContext) {
            this.namespaceContext = namespaceContext;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }
    }

    private class IdentityConstraintMap {
        private Map<String, Map<String, IdentityConstraint>> constraintStore = new Hashtable<String, Map<String, IdentityConstraint>>();

        public void add(IdentityConstraint constraint) {
            String[] fields = IdentityConstraintDataBuilder.this.getUriLocalName(constraint.getName());
            if (fields[0] == null || fields[1] == null) {
                return;
            }
            Map<String, IdentityConstraint> identityStore = this.constraintStore.get(fields[0]);
            if (identityStore == null) {
                identityStore = new Hashtable<String, IdentityConstraint>();
                this.constraintStore.put(fields[0], identityStore);
            }
            identityStore.put(fields[1], constraint);
        }

        public IdentityConstraint get(String constraintName) {
            String[] fields = IdentityConstraintDataBuilder.this.getUriLocalName(constraintName);
            if (fields[0] == null || fields[1] == null) {
                return null;
            }
            Map<String, IdentityConstraint> identityStore = this.constraintStore.get(fields[0]);
            return identityStore == null ? null : identityStore.get(fields[1]);
        }
    }
}

