/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ConstraintNode;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.util.ParserHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetSchemaBuilder
extends AbstractDataBuilder<Map<String, ConstraintNode>> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.TargetSchemaBuilder";
    protected Map<String, ConstraintNode> dataStructure = new HashMap<String, ConstraintNode>();
    protected boolean uriElementFound = false;

    @Override
    public Map<String, ConstraintNode> getDataStructure() {
        return this.dataStructure;
    }

    public void startSchema(String uri) {
    }

    public void endSchema(String uri) {
        Map substitionMap = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.SubstitutionBuilder");
        for (String namespaceURI : substitionMap.keySet()) {
            String elementNameNonNS = ParserHelper.removeNameSpace(namespaceURI);
            ConstraintNode targetSchemaNode = this.dataStructure.get(elementNameNonNS);
            if (targetSchemaNode != null) {
                Object substitionName = substitionMap.get(namespaceURI);
                ConstraintNode subTargetSchemaNode = this.dataStructure.get(substitionName);
                targetSchemaNode.setSubstitutionGroup(subTargetSchemaNode);
                continue;
            }
            Map substitutionMap = (Map)substitionMap.get(namespaceURI);
            for (String elementName : substitutionMap.keySet()) {
                String substitutedElement = (String)substitutionMap.get(elementName);
                substitutedElement = substitutedElement == null ? null : ParserHelper.removeNameSpace(substitutedElement);
                ConstraintNode subTargetSchemaNode = this.dataStructure.get(substitutedElement);
                if (subTargetSchemaNode == null) continue;
                this.dataStructure.put(elementNameNonNS, subTargetSchemaNode);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (!"http://www.w3.org/2001/XMLSchema".equals(uri)) {
            return;
        }
        if ("schema".equals(localName)) {
            this.startSchema(uri);
        } else if ("element".equals(localName)) {
            String elementName = attributes.getValue("name");
            String targetElement = attributes.getValue("http://www.w3.org/2008/03/sml", "targetElement");
            String targetType = attributes.getValue("http://www.w3.org/2008/03/sml", "targetType");
            String targetRequired = attributes.getValue("http://www.w3.org/2008/03/sml", "targetRequired");
            if (targetElement != null || targetType != null || targetRequired != null) {
                ConstraintNode schemaNode = new ConstraintNode(elementName, this.getFilePath(), this.locator == null ? -1 : this.locator.getLineNumber(), this.locator == null ? -1 : this.locator.getColumnNumber());
                schemaNode.setTargetElement(SMLValidatorUtil.toQName(super.getPrefixMap(), super.getTargetNamespace(), targetElement));
                schemaNode.setTargetType(SMLValidatorUtil.toQName(super.getPrefixMap(), super.getTargetNamespace(), targetType));
                schemaNode.setTargetRequired(targetRequired);
                this.dataStructure.put(elementName, schemaNode);
            }
        } else if (this.isTargetConstraintPresent(attributes)) {
            this.getMessageOutputter().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createWarningMessage(this.locator.getLineNumber(), SMLValidationMessages.targetBadDeclaration));
        }
    }

    private boolean isTargetConstraintPresent(Attributes attributes) {
        return attributes.getValue("http://www.w3.org/2008/03/sml", "targetElement") != null || attributes.getValue("http://www.w3.org/2008/03/sml", "targetType") != null || attributes.getValue("http://www.w3.org/2008/03/sml", "targetRequired") != null;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if ("schema".equals(localName)) {
            this.endSchema(uri);
        }
    }

    @Override
    public byte getPhase() {
        return 1;
    }
}

