/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.smlvalidators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathFunctionException;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementTypeMap;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TypeNode;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AcyclicDataTypesList;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ReferenceGraphDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.reference.DerefXPathFunction;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcyclicValidator
extends AbstractSMLValidator {
    private List<ResolvedReference> graphNodes = new ArrayList<ResolvedReference>();
    private Map<String, Map<String, TypeNode>> inheritanceHierarchy;
    private ElementTypeMap typeMap;

    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry databuilderRegistry = DataBuilderRegistry.instance();
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.AcyclicDataTypesList", new AcyclicDataTypesList());
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ReferenceGraphDataBuilder", new ReferenceGraphDataBuilder());
    }

    @Override
    public boolean validate() {
        this.setTaskName(SMLValidationMessages.validationAcyclic);
        Iterator acyclicTypes = (Iterator)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.AcyclicDataTypesList");
        Map referenceGraph = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.ReferenceGraphDataBuilder");
        IDataBuilder<?> inheritanceDataBuilder = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl");
        Map domDocuments = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder");
        this.typeMap = (ElementTypeMap)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.ElementTypeMapDataBuilder");
        IValidationOutput<String, Object> output = this.getValidationOutput();
        if (referenceGraph == null || acyclicTypes == null) {
            output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, SMLValidationMessages.acyclicUnknown));
            output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, referenceGraph == null ? SMLValidationMessages.acyclicNoReferenceGraph : (acyclicTypes == null ? SMLValidationMessages.acyclicNoAcyclicTypeList : SMLValidationMessages.acyclicNoInheritanceMap)));
            if (this.shouldAbortOnError()) {
                return false;
            }
        }
        if (!inheritanceDataBuilder.isStructureValid()) {
            output.reportMessage(inheritanceDataBuilder.getErrorMessage());
            if (this.shouldAbortOnError()) {
                return false;
            }
        }
        this.inheritanceHierarchy = (Map)inheritanceDataBuilder.getDataStructure();
        String[] documentAlias = new String[referenceGraph.size()];
        int counter = 0;
        Iterator iterator = referenceGraph.keySet().iterator();
        while (iterator.hasNext()) {
            documentAlias[counter++] = (String)iterator.next();
        }
        Iterator iter = acyclicTypes;
        while (iter.hasNext()) {
            TypeNode elementType = (TypeNode)iter.next();
            int i = 0;
            while (i < documentAlias.length) {
                this.graphNodes.clear();
                Node documentNode = (Node)domDocuments.get(documentAlias[i]);
                if (this.isCyclePresent(documentNode, elementType)) {
                    output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.acyclicCycleFound, (Object)elementType.getType())));
                    StringBuffer cycle = new StringBuffer();
                    int j = 0;
                    int nodesCount = this.graphNodes.size();
                    while (j < nodesCount) {
                        cycle.append(j > 0 ? ", " : "");
                        cycle.append(this.graphNodes.get(j).reference);
                        ++j;
                    }
                    if (cycle.length() > 0) {
                        output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.acyclicDetectedCycle, (Object)cycle.toString())));
                    }
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean isCyclePresent(Node node, TypeNode elementType) {
        ResolvedReference[] resolvedReferences = this.resolveReferences(node, elementType);
        int i = 0;
        while (i < resolvedReferences.length) {
            if (this.graphNodes.contains(resolvedReferences[i])) {
                this.graphNodes.add(resolvedReferences[i]);
                return true;
            }
            this.graphNodes.add(resolvedReferences[i]);
            if (this.isCyclePresent(resolvedReferences[i].resolvedReference, elementType)) {
                return true;
            }
            this.graphNodes.remove(resolvedReferences[i]);
            ++i;
        }
        return false;
    }

    private ResolvedReference[] resolveReferences(Node node, TypeNode elementType) {
        if (node == null) {
            return new ResolvedReference[0];
        }
        if (this.checkInstanceType(node, elementType)) {
            ResolvedReference[] resolvedReferenceArray;
            ResolvedReference resolvedReference = this.resolveReference(node);
            if (resolvedReference == null) {
                resolvedReferenceArray = new ResolvedReference[]{};
            } else {
                ResolvedReference[] resolvedReferenceArray2 = new ResolvedReference[1];
                resolvedReferenceArray = resolvedReferenceArray2;
                resolvedReferenceArray2[0] = resolvedReference;
            }
            return resolvedReferenceArray;
        }
        NodeList children = node.getChildNodes();
        ArrayList<ResolvedReference> references = new ArrayList<ResolvedReference>();
        this.findReferences(references, children, elementType);
        return references.toArray(new ResolvedReference[references.size()]);
    }

    private void findReferences(List<ResolvedReference> references, NodeList nodeList, TypeNode elementType) {
        int i = 0;
        int childCount = nodeList.getLength();
        while (i < childCount) {
            ResolvedReference resolvedReference;
            Node child = nodeList.item(i);
            if (this.checkInstanceType(child, elementType) && (resolvedReference = this.resolveReference(child)) != null) {
                references.add(resolvedReference);
            }
            if (child.hasChildNodes()) {
                this.findReferences(references, child.getChildNodes(), elementType);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkInstanceType(Node node, TypeNode elementType) {
        type = this.typeMap.getType(node.getNamespaceURI(), node.getLocalName());
        namespace = node.getNamespaceURI() == null ? "" : node.getNamespaceURI();
        nestedMap = SMLValidatorUtil.retrieveNestedMap(this.inheritanceHierarchy, namespace, false);
        if (namespace.equals(elementType.getUri())) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            if (type.equals(elementType.getType())) {
                return true;
            }
            typeNode = nestedMap == null ? null : (TypeNode)nestedMap.get(type);
            v0 = type = typeNode == null ? null : typeNode.getType();
lbl10:
            // 2 sources

            ** while (type != null)
        }
lbl11:
        // 1 sources

        return false;
    }

    private ResolvedReference resolveReference(Node node) {
        String reference = SMLValidatorUtil.extractReference(node);
        if (reference == null) {
            return null;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(reference);
        try {
            NodeList result;
            Object output = DerefXPathFunction.instance().evaluate(arguments);
            if (output instanceof NodeList && (result = (NodeList)output).getLength() == 1) {
                return new ResolvedReference(reference, result.item(0));
            }
        }
        catch (XPathFunctionException xPathFunctionException) {}
        return null;
    }

    private static class ResolvedReference {
        private String reference;
        private Node resolvedReference;

        public ResolvedReference(String reference, Node resolvedReference) {
            this.reference = reference;
            this.resolvedReference = resolvedReference;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ResolvedReference)) {
                return false;
            }
            ResolvedReference other = (ResolvedReference)o;
            return this.resolvedReference == null ? other.resolvedReference == null : this.resolvedReference.equals(other.resolvedReference);
        }
    }
}

