/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.smlvalidators;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.cosmos.rm.validation.internal.artifacts.IdentityConstraintStructure;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationConstants;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DocumentDOMBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ElementDeclarationBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IdentityConstraintDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ReferenceExtractor;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityConstraintValidator
extends AbstractSMLValidator {
    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry databuilderRegistry = DataBuilderRegistry.instance();
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder", new DocumentDOMBuilder());
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.IdentityConstraintDataBuilder", new IdentityConstraintDataBuilder());
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ReferenceExtractor", new ReferenceExtractor());
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementDeclarationBuilder", new ElementDeclarationBuilder());
    }

    @Override
    public boolean validate() {
        boolean isValidationSuccess = true;
        this.setTaskName(SMLValidationMessages.validationIdentity);
        DocumentDOMBuilder builder = (DocumentDOMBuilder)DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder");
        Object domDocuments = builder == null ? null : builder.getDataStructure();
        IdentityConstraintStructure identityStruct = (IdentityConstraintStructure)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.IdentityConstraintDataBuilder");
        SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.ReferenceExtractor");
        IValidationOutput<String, Object> output = this.getValidationOutput();
        if (domDocuments == null || identityStruct == null) {
            output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, SMLValidationMessages.identityMissingStructures));
            isValidationSuccess = false;
        }
        Map<String, List<int[]>> constrainedInstances = identityStruct.getConstrainedInstances();
        for (String documentAlias : constrainedInstances.keySet()) {
            Node node = (Node)domDocuments.get(documentAlias);
            if (node == null) continue;
            List<int[]> indices = constrainedInstances.get(documentAlias);
            int i = 0;
            int indexCount = indices.size();
            while (i < indexCount) {
                String error = this.validateIdentityConstraints(identityStruct, node, documentAlias, indices.get(i));
                if (error != null) {
                    output.reportMessage(SMLValidatorUtil.createValidationMessage(builder, node, error));
                    isValidationSuccess = false;
                    if (this.shouldAbortOnError()) {
                        return false;
                    }
                }
                ++i;
            }
        }
        Map<String, List<int[]>> orphanedConstrainedInstances = identityStruct.getOrphanedConstrainedInstances();
        List orphanedDOMDocuments = (List)domDocuments.get("no_alias");
        int orphanSize = orphanedDOMDocuments == null ? 0 : orphanedDOMDocuments.size();
        Iterator<String> orphanIndices = orphanedConstrainedInstances.keySet().iterator();
        while (orphanIndices.hasNext()) {
            Node node;
            int orphanIndex = Integer.parseInt(orphanIndices.next());
            if (orphanIndex < 0 || orphanIndex >= orphanSize || (node = (Node)orphanedDOMDocuments.get(orphanIndex)) == null) continue;
            List<int[]> listOfIndices = orphanedConstrainedInstances.get(String.valueOf(orphanIndex));
            int i = 0;
            int indicesCount = listOfIndices.size();
            while (i < indicesCount) {
                int[] indices = listOfIndices.get(i);
                String error = this.validateIdentityConstraints(identityStruct, node, null, indices);
                if (error != null) {
                    output.reportMessage(SMLValidatorUtil.createValidationMessage(builder, node, error));
                    isValidationSuccess = false;
                    if (this.shouldAbortOnError()) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return isValidationSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String validateIdentityConstraints(IdentityConstraintStructure identityStruct, Node context, String documentAlias, int[] indices) {
        IdentityConstraintDataBuilder.IdentityConstraint[] constraints;
        IdentityConstraintDataBuilder.IdentityConstraint[] identityConstraintArray = constraints = (context = this.findNode(context, indices)) == null ? null : identityStruct.retrieveConstraint(context.getNamespaceURI(), context.getLocalName());
        if (context == null || constraints == null) {
            return null;
        }
        Hashtable<String, List<String>> documentConstraints = new Hashtable<String, List<String>>();
        IdentityConstraintDataBuilder.IdentityConstraint currentConstraint = null;
        String error = null;
        try {
            int i = 0;
            while (i < constraints.length) {
                block13: {
                    currentConstraint = constraints[i];
                    XPathExpression selector = null;
                    List<String> fields = null;
                    ArrayList<String> fieldValues = new ArrayList<String>();
                    XPath xPath = SMLValidatorUtil.xpath;
                    synchronized (xPath) {
                        if (constraints[i].getNamespaceContext() != null) {
                            SMLValidatorUtil.xpath.setNamespaceContext(constraints[i].getNamespaceContext());
                        }
                        selector = SMLValidatorUtil.xpath.compile(currentConstraint.getSelector());
                        fields = currentConstraint.getFields();
                        NodeList selectorList = (NodeList)selector.evaluate(context, XPathConstants.NODESET);
                        if (selectorList == null || selectorList.getLength() <= 0) {
                            break block13;
                        }
                        fieldValues = new ArrayList();
                        int j = 0;
                        int nodeCount = selectorList.getLength();
                        while (j < nodeCount) {
                            String fieldsPerNode = "";
                            int k = 0;
                            int fieldCount = fields.size();
                            while (k < fieldCount) {
                                Node currentNode = selectorList.item(j);
                                String currentField = this.extractField(currentNode, fields.get(k));
                                fieldsPerNode = String.valueOf(fieldsPerNode) + (currentField == null ? "" : (fieldsPerNode.length() > 0 ? ", " + currentField : currentField));
                                if (currentField == null && currentConstraint.getType() == 0) {
                                    return NLS.bind((String)SMLValidationMessages.identityMissingField, (Object[])new String[]{fields.get(k), currentConstraint.getName(), documentAlias == null ? SMLValidationMessages.commonNoAlias : documentAlias});
                                }
                                ++k;
                            }
                            fieldValues.add(fieldsPerNode);
                            ++j;
                        }
                    }
                    documentConstraints.put(currentConstraint.getName(), fieldValues);
                    error = this.validateConstraint(documentConstraints, constraints[i], fieldValues, documentAlias);
                    if (error != null) {
                        return error;
                    }
                }
                ++i;
            }
        }
        catch (XPathExpressionException e) {
            return String.valueOf(NLS.bind((String)SMLValidationMessages.identityXPathError, (Object[])new String[]{currentConstraint.getSelector(), currentConstraint.getName()})) + IValidationConstants.LINE_SEPARATOR + (e.getMessage() == null ? "" : e.getMessage());
        }
        return null;
    }

    private String validateConstraint(Map<String, List<String>> constraintMap, IdentityConstraintDataBuilder.IdentityConstraint constraint, List<String> fields, String documentAlias) {
        switch (constraint.getType()) {
            case 0: 
            case 2: {
                Hashtable<String, String> indexedHashtable = new Hashtable<String, String>();
                int i = 0;
                int listSize = fields.size();
                while (i < listSize) {
                    if (indexedHashtable.get(fields.get(i)) != null) {
                        return NLS.bind((String)SMLValidationMessages.identityDuplicateKey, (Object[])new String[]{constraint.getName(), documentAlias == null ? SMLValidationMessages.commonNoAlias : documentAlias, fields.get(i).toString()});
                    }
                    indexedHashtable.put(fields.get(i), "");
                    ++i;
                }
                break;
            }
            case 1: {
                String reference = constraint.getReference();
                List<String> referencedConstraint = null;
                if (reference == null) {
                    return NLS.bind((String)SMLValidationMessages.identityMissingReference, (Object)constraint.getName());
                }
                referencedConstraint = constraintMap.get(reference);
                if (referencedConstraint == null) {
                    return NLS.bind((String)SMLValidationMessages.identityMissingConstraint, (Object)constraint.getName());
                }
                int i = 0;
                int fieldSize = fields.size();
                while (i < fieldSize) {
                    String currentField = fields.get(i);
                    boolean foundField = false;
                    int j = 0;
                    int referenceList = referencedConstraint.size();
                    while (j < referenceList) {
                        if (currentField.equals(referencedConstraint.get(j))) {
                            foundField = true;
                            break;
                        }
                        ++j;
                    }
                    if (!foundField) {
                        return NLS.bind((String)SMLValidationMessages.identityMissingKey, (Object[])new String[]{currentField, constraint.getName()});
                    }
                    ++i;
                }
                break;
            }
        }
        return null;
    }

    private String extractField(Node context, String field) {
        Node fieldNode;
        block6: {
            XPathExpression fieldXPath = SMLValidatorUtil.xpath.compile(field);
            NodeList nodeList = (NodeList)fieldXPath.evaluate(context, XPathConstants.NODESET);
            Node node = fieldNode = nodeList.getLength() == 1 ? nodeList.item(0) : null;
            if (fieldNode != null) break block6;
            return null;
        }
        try {
            if (field.charAt(0) == '@') {
                return fieldNode.getNodeValue();
            }
            NodeList childNodes = fieldNode.getChildNodes();
            StringBuffer fieldText = new StringBuffer();
            int i = 0;
            int chidNodeCount = childNodes.getLength();
            while (i < chidNodeCount) {
                Node currentNode = childNodes.item(0);
                if (3 != currentNode.getNodeType()) {
                    return field.toString();
                }
                fieldText.append(currentNode.getNodeValue() == null ? "" : currentNode.getNodeValue());
                ++i;
            }
            return fieldText.toString();
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    private Node findNode(Node node, int[] indices) {
        Node currentNode = node;
        NodeList nodeList = null;
        int i = 1;
        while (i < indices.length) {
            nodeList = node.getChildNodes();
            if (indices[i] < 0 || indices[i] >= nodeList.getLength()) {
                return null;
            }
            currentNode = nodeList.item(indices[i]);
            ++i;
        }
        return currentNode;
    }
}

