/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations.cmdbf;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfMessages;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRecordType;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.rm.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.AbstractSMLConstraintHandler;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.CMDBfUtil;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileInstanceDocument;
import org.w3c.dom.Node;

public class ItemRecordHandler
extends AbstractSMLConstraintHandler {
    protected INodes handle(INodes context, IConstraint constraint) throws CMDBfServiceException {
        try {
            INodes results = this.retrieveContext(context);
            IGraphElement[] elements = results.getElements();
            ISMLRepository repository = this.getRepository();
            IRecordType recordType = (IRecordType)constraint;
            String namespace = CMDBfServicesUtil.toString((URI)recordType.getNamespace());
            String localName = recordType.getLocalName();
            ArrayList<IGraphElement> revisedList = new ArrayList<IGraphElement>();
            int i = 0;
            while (i < elements.length) {
                Node rootNode;
                SMLFileInstanceDocument document = CMDBfUtil.retrieveDocument(repository, (IItem)elements[i]);
                Node node = rootNode = document == null ? null : document.getDOMDocument().getFirstChild();
                if (rootNode != null) {
                    if (namespace.equals(rootNode.getNamespaceURI()) && localName.equals(rootNode.getLocalName())) {
                        revisedList.add(elements[i]);
                    } else {
                        String typeLocalName;
                        String typeNamespace;
                        int colonInx;
                        SMLRepositoryUtil.parseDocument(document, repository);
                        Map typeInfo = (Map)repository.getProperty("org.eclipse.cosmos.rm.repository.TYPE_INFORMATION", (Object)null);
                        String type = SMLRepositoryUtil.retrieveType(typeInfo, namespace, localName);
                        if (type != null && (colonInx = type.lastIndexOf(58)) >= 0 && SMLRepositoryUtil.isDerivedType(repository, rootNode, typeNamespace = type.substring(0, colonInx), typeLocalName = type.substring(colonInx + 1))) {
                            revisedList.add(elements[i]);
                        }
                    }
                }
                ++i;
            }
            results.setElements(revisedList.toArray(new IGraphElement[revisedList.size()]));
            return results;
        }
        catch (RepositoryOperationException e) {
            throw new CMDBfServiceException(1, 5, CMDBfMessages.faultsQueryError, CMDBfInternalUtility.createTextNode((String)e.getLocalizedMessage()), (Throwable)e);
        }
    }
}

