/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.editor;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.cosmos.rm.smlif.internal.SMLPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class ImageManager {
    public static final String T_LCL = "lcl16";
    public static final String T_TOOL = "tool16";
    public static final String T_VIEW = "view16";
    public static final String T_OBJ = "obj16";
    public static final String T_OVR = "ovr16";
    public static final String T_WIZBAN = "wizban";
    private URL iconBaseURL;
    private ImageRegistry imageRegistry;
    private boolean imagesWereLoaded = false;
    private boolean initialized = false;

    public void initialize(URL iconBaseURL, ImageRegistry imageRegistry) {
        this.iconBaseURL = iconBaseURL;
        this.imageRegistry = imageRegistry;
    }

    protected void checkImages() {
        if (this.imagesWereLoaded) {
            return;
        }
        this.addImages();
        this.imagesWereLoaded = true;
    }

    protected abstract void addImages();

    protected ImageDescriptor add(String prefix, String name) {
        ImageDescriptor imageDescriptor = this.createImageDescriptor(prefix, name);
        if (imageDescriptor != null) {
            this.imageRegistry.put(name, imageDescriptor);
        }
        return imageDescriptor;
    }

    protected ImageDescriptor add(String prefixType, String prefix, String name) {
        ImageDescriptor imageDescriptor = this.createImageDescriptor(String.valueOf(prefixType) + prefix, name);
        if (imageDescriptor != null) {
            this.imageRegistry.put(String.valueOf(prefixType) + name, imageDescriptor);
        }
        return imageDescriptor;
    }

    protected boolean add(String key, ImageDescriptor imageDescriptor) throws IllegalArgumentException {
        if (key == null || imageDescriptor == null) {
            return false;
        }
        this.imageRegistry.put(key, imageDescriptor);
        return true;
    }

    protected ImageDescriptor createImageDescriptor(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)this.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    protected URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (this.iconBaseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(this.iconBaseURL, buffer.toString());
    }

    public ImageDescriptor getImageDescriptor(String key) {
        this.checkImages();
        return this.imageRegistry.getDescriptor(key);
    }

    public Image getImage(String key) {
        this.checkImages();
        return this.imageRegistry.get(key);
    }

    public ImageDescriptor getImageDescriptor(String prefixType, String key) {
        return this.getImageDescriptor(String.valueOf(prefixType) + key);
    }

    public Image getImage(String prefixType, String key) {
        return this.getImage(String.valueOf(prefixType) + key);
    }

    public void setImageDescriptors(IAction action, String name) {
        ImageDescriptor imageDescriptor = this.getImageDescriptor("d", name);
        if (imageDescriptor != null) {
            action.setDisabledImageDescriptor(imageDescriptor);
        }
        if ((imageDescriptor = this.getImageDescriptor("c", name)) != null) {
            action.setHoverImageDescriptor(imageDescriptor);
        }
        if ((imageDescriptor = this.getImageDescriptor("e", name)) != null) {
            action.setImageDescriptor(imageDescriptor);
        }
    }

    public static void initializeImages(ImageManager imageManager, final AbstractUIPlugin uiPlugin) {
        imageManager.initialized = true;
        Runnable operation = new Runnable(){

            public void run() {
                try {
                    ImageManager.this.initialize(new URL(uiPlugin.getBundle().getEntry("/"), "icons/full/"), uiPlugin.getImageRegistry());
                }
                catch (Exception e) {
                    SMLPlugin.logError(e);
                }
            }
        };
        if (Display.getCurrent() == Display.getDefault()) {
            operation.run();
        } else {
            Display.getDefault().asyncExec(operation);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

