/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.export.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.resource.ISMLDocument;
import org.eclipse.cosmos.rm.repository.resource.ISMLMetadata;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.EditableComboBoxCellEditor;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportToSMLIFWizard;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.RuleBindingTableCellModifier;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.RuleBindingTableLabelProvider;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.RuleFindingFileHandler;
import org.eclipse.cosmos.rm.validation.internal.artifacts.RuleBinding;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportToSMLIFWizardPage3
extends WizardPage {
    protected static final String DOCUMENT_COLUMN = "DOCUMENT_COLUMN";
    protected static final String RULE_COLUMN = "RULE_COLUMN";
    protected static final String ALIAS_COLUMN = "ALIAS_COLUMN";
    protected TableViewer ruleBindingsTableViewer;
    protected EditableComboBoxCellEditor aliasChoicesCombo;
    protected EditableComboBoxCellEditor ruleChoicesCombo;
    protected List<RuleBinding> ruleBindings;
    protected List<ISMLDocument> documents;

    public ExportToSMLIFWizardPage3(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setTitle(pageName);
    }

    public void createControl(Composite parent) {
        Composite topComponent = new Composite(parent, 0);
        GridData topComponentData = new GridData(768);
        topComponent.setLayoutData((Object)topComponentData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        topComponent.setLayout((Layout)layout);
        this.createRuleBindingsLabel(topComponent);
        this.createRuleBindingsTable(topComponent);
        this.createAddRemoveButtons(topComponent);
        this.setControl((Control)topComponent);
        this.setPageComplete(true);
        Dialog.applyDialogFont((Control)topComponent);
    }

    protected void createAddRemoveButtons(Composite parent) {
        Composite buttonComposite = ExportToSMLIFWizard.createVerticalButtonPanel(parent);
        Button addButton = ExportToSMLIFWizard.createVerticalButtonPanelButton(buttonComposite, SMLMessages.exportWizardAddButtonLabelNonPrompting);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                RuleBinding newRuleBinding = new RuleBinding();
                ((Collection)ExportToSMLIFWizardPage3.this.ruleBindingsTableViewer.getInput()).add(newRuleBinding);
                ExportToSMLIFWizardPage3.this.ruleBindingsTableViewer.refresh();
                ExportToSMLIFWizardPage3.this.ruleBindingsTableViewer.editElement((Object)newRuleBinding, 0);
            }
        });
        Button removeButton = ExportToSMLIFWizard.createVerticalButtonPanelButton(buttonComposite, SMLMessages.exportWizardRemoveButtonText);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                IStructuredSelection selection = (IStructuredSelection)ExportToSMLIFWizardPage3.this.ruleBindingsTableViewer.getSelection();
                ((Collection)ExportToSMLIFWizardPage3.this.ruleBindingsTableViewer.getInput()).removeAll(selection.toList());
                ExportToSMLIFWizardPage3.this.ruleBindingsTableViewer.refresh();
            }
        });
    }

    protected void createRuleBindingsTable(Composite parent) {
        this.ruleBindingsTableViewer = new TableViewer(parent, 65538);
        this.setTableProperties();
        ControlListener listener = this.createTableControlListener(this.ruleBindingsTableViewer.getTable());
        parent.addControlListener(listener);
    }

    protected void setTableProperties() {
        TableLayout layout = new TableLayout();
        Table ruleBindingsTable = this.ruleBindingsTableViewer.getTable();
        ruleBindingsTable.setLayout((Layout)layout);
        ruleBindingsTable.setLinesVisible(true);
        ruleBindingsTable.setLayoutData((Object)new GridData(4, -1, true, false));
        ruleBindingsTable.setHeaderVisible(true);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        ruleBindingsTable.setLayoutData((Object)gridData);
        String[] columnNames = new String[]{SMLMessages.exportWizardRuleTableAliasColumn, SMLMessages.exportWizardRuleTableRuleColumn};
        String[] columnProperties = new String[]{ALIAS_COLUMN, RULE_COLUMN};
        ColumnPixelData columnLayout = new ColumnPixelData(180, true);
        TableColumn column = null;
        int i = 0;
        while (i < columnNames.length) {
            column = new TableColumn(ruleBindingsTable, 16384);
            column.setResizable(columnLayout.resizable);
            column.setText(columnNames[i]);
            layout.addColumnData((ColumnLayoutData)columnLayout);
            ++i;
        }
        this.aliasChoicesCombo = new EditableComboBoxCellEditor((Composite)ruleBindingsTable, new String[0], 4);
        this.ruleChoicesCombo = new EditableComboBoxCellEditor((Composite)ruleBindingsTable, new String[0], 4);
        this.ruleBindingsTableViewer.setCellEditors(new CellEditor[]{this.aliasChoicesCombo, this.ruleChoicesCombo});
        this.ruleBindingsTableViewer.setCellModifier((ICellModifier)new RuleBindingTableCellModifier(Arrays.asList(columnProperties), this, this.getExportWizard().getPage2().getAliases()));
        this.ruleBindingsTableViewer.setColumnProperties(columnProperties);
        this.updateComboChoices();
        this.ruleBindingsTableViewer.setLabelProvider((IBaseLabelProvider)new RuleBindingTableLabelProvider());
        this.ruleBindingsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.ruleBindingsTableViewer.setInput(this.ruleBindings);
        ruleBindingsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                IStructuredSelection tableSelection = (IStructuredSelection)ExportToSMLIFWizardPage3.this.ruleBindingsTableViewer.getSelection();
                RuleBinding selectedBinding = (RuleBinding)tableSelection.getFirstElement();
                if (selectedBinding == null) {
                    return;
                }
                ExportToSMLIFWizardPage3.this.aliasChoicesCombo.setValue(selectedBinding.getAlias());
                ExportToSMLIFWizardPage3.this.ruleChoicesCombo.setValue(selectedBinding.getRule());
            }
        });
    }

    protected void updateComboChoices() {
        if (this.aliasChoicesCombo == null) {
            return;
        }
        ArrayList<String> allAliases = new ArrayList<String>();
        allAliases.add("<all>");
        this.documents = this.getDocuments();
        for (ISMLDocument smlDoc : this.documents) {
            String[] smlDocAliases = smlDoc.getMetadata().getAliases();
            int i = 0;
            while (i < smlDocAliases.length) {
                allAliases.add(smlDocAliases[i]);
                ++i;
            }
        }
        Collections.sort(allAliases);
        String[] aliases = allAliases.toArray(new String[0]);
        this.aliasChoicesCombo.setItems(aliases);
        this.ruleChoicesCombo.setItems(this.getRuleListChoices());
    }

    protected final int calculateRemainingHorizontalSpace(Table table) {
        boolean visible;
        Rectangle bounds = table.getBounds();
        boolean bl = visible = bounds.width != 0 || bounds.height != 0;
        if (!visible) {
            return 0;
        }
        int width = bounds.width;
        int tableBorderWidth = table.getBorderWidth();
        width -= tableBorderWidth * 2;
        ScrollBar scrollbar = table.getVerticalBar();
        Point scrollbarSize = scrollbar.getSize();
        width -= scrollbarSize.x;
        TableColumn[] columns = table.getColumns();
        int count = columns.length;
        int cumulative = 0;
        int i = 1;
        while (i < count) {
            TableColumn column = columns[i];
            int columnWidth = column.getWidth();
            cumulative += columnWidth;
            ++i;
        }
        int remainder = width - cumulative;
        return remainder;
    }

    protected ControlListener createTableControlListener(final Table table) {
        return new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ExportToSMLIFWizardPage3.this.handleTableResized(table);
            }
        };
    }

    protected void handleTableResized(Table table) {
        int width = this.calculateRemainingHorizontalSpace(table);
        if (width == 0) {
            return;
        }
        TableColumn[] columns = table.getColumns();
        TableColumn column = columns[0];
        column.setWidth(width);
    }

    protected void createRuleBindingsLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(SMLMessages.exportWizardRuleBindingsSectionLabel);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    protected Collection<ISMLDocument> getModel() {
        return this.getExportWizard().getSelectedFiles().values();
    }

    protected ExportToSMLIFWizard getExportWizard() {
        return (ExportToSMLIFWizard)this.getWizard();
    }

    protected String[] getRuleListChoices() {
        ArrayList<String> result = new ArrayList<String>();
        Collection<ISMLDocument> selectedFiles = this.getModel();
        for (ISMLDocument file : selectedFiles) {
            ISMLMetadata metadata = file.getMetadata();
            if (metadata.getDocumentType() == 1) continue;
            String[] aliases = SMLCommonUtil.retrieveAliases(this.getExportWizard().getPage2().getAliases(), file);
            if (!this.isRule(file)) continue;
            if (aliases.length > 0) {
                result.add(aliases[0]);
                continue;
            }
            result.add(SMLRepositoryUtil.getDocumentName((ISMLDocument)file));
        }
        return result.toArray(new String[0]);
    }

    private boolean isRule(ISMLDocument file) {
        RuleFindingFileHandler handler = new RuleFindingFileHandler();
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        try {
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse(file.getMetadata().getId(), (DefaultHandler)handler);
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return handler.hasRule();
    }

    protected boolean definitionHasRule(IFile file) {
        RuleFindingFileHandler handler = new RuleFindingFileHandler();
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        try {
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse(file.getLocation().toString(), (DefaultHandler)handler);
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return handler.hasRule();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.handleTableResized(this.ruleBindingsTableViewer.getTable());
        if (visible) {
            this.ruleBindingsTableViewer.setInput(this.getRuleBindings());
            this.ruleBindingsTableViewer.refresh();
        }
    }

    public List<RuleBinding> getRuleBindings() {
        if (this.ruleBindings == null) {
            this.initRuleBindings();
        }
        return this.ruleBindings;
    }

    private void initRuleBindings() {
        this.ruleBindings = new ArrayList<RuleBinding>();
        Collection<ISMLDocument> documents = this.getModel();
        for (ISMLDocument currentDocument : documents) {
            ISMLMetadata metadata = currentDocument.getMetadata();
            Map boundRules = metadata.getBoundRules();
            if (boundRules == null) continue;
            for (String alias : boundRules.keySet()) {
                List documentRules = (List)boundRules.get(alias);
                int j = 0;
                int documentRulesCount = documentRules.size();
                while (j < documentRulesCount) {
                    RuleBinding ruleBinding = new RuleBinding();
                    ruleBinding.setAlias(alias);
                    ruleBinding.setRule((String)documentRules.get(j));
                    this.ruleBindings.add(ruleBinding);
                    ++j;
                }
            }
        }
    }

    public List<ISMLDocument> getDocuments() {
        return new ArrayList<ISMLDocument>(this.getModel());
    }
}

