/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.export.ui;

import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportToSMLIFWizardPage3;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.RuleBindingTableLabelProvider;
import org.eclipse.cosmos.rm.validation.internal.artifacts.RuleBinding;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBindingTableCellModifier
implements ICellModifier {
    private static final Integer NOT_FOUND = new Integer(-1);
    private ExportToSMLIFWizardPage3 wizardPage;
    private List<String> columnProperties;
    private Map<String, String[]> userDefinedAliases;

    public RuleBindingTableCellModifier(List<String> list, ExportToSMLIFWizardPage3 wizardPage, Map<String, String[]> userDefinedAliases) {
        this.wizardPage = wizardPage;
        this.columnProperties = list;
        this.userDefinedAliases = userDefinedAliases;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.columnProperties.indexOf(property);
        Object modelDataForColumn = RuleBindingTableLabelProvider.getModelDataForColumn(element, columnIndex);
        if (modelDataForColumn == null) {
            return NOT_FOUND;
        }
        if ("ALIAS_COLUMN".equals(property)) {
            String alias = (String)modelDataForColumn;
            String[] aliasChoices = this.wizardPage.aliasChoicesCombo.getItems();
            int i = 0;
            while (i < aliasChoices.length) {
                if (aliasChoices[i].equals(alias)) {
                    return new Integer(i);
                }
                ++i;
            }
            return alias;
        }
        if ("RULE_COLUMN".equals(property)) {
            String rule = (String)modelDataForColumn;
            String[] ruleChoices = this.wizardPage.ruleChoicesCombo.getItems();
            int i = 0;
            while (i < ruleChoices.length) {
                if (ruleChoices[i].equals(rule)) {
                    return new Integer(i);
                }
                ++i;
            }
            return rule;
        }
        return NOT_FOUND;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.columnProperties.indexOf(property);
        RuleBinding ruleBinding = null;
        if (element instanceof Item) {
            TableItem item = (TableItem)element;
            ruleBinding = (RuleBinding)item.getData();
        } else {
            ruleBinding = (RuleBinding)element;
        }
        int selectionIndex = -1;
        if (value instanceof Integer) {
            selectionIndex = (Integer)value;
        }
        switch (columnIndex) {
            case 0: {
                String alias = null;
                alias = selectionIndex == -1 ? ((CCombo)this.wizardPage.aliasChoicesCombo.getControl()).getText() : this.wizardPage.aliasChoicesCombo.getItems()[selectionIndex];
                ruleBinding.setAlias(alias);
                break;
            }
            case 1: {
                String rule = null;
                rule = selectionIndex == -1 ? ((CCombo)this.wizardPage.ruleChoicesCombo.getControl()).getText() : this.wizardPage.ruleChoicesCombo.getItems()[selectionIndex];
                ruleBinding.setRule(rule);
                break;
            }
        }
        this.wizardPage.ruleBindingsTableViewer.refresh();
    }
}

