/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations;

import org.eclipse.cosmos.rm.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.internal.operations.AbstractListenerManager;
import org.eclipse.cosmos.rm.repository.operations.ISMLOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSMLOperation
extends AbstractListenerManager
implements ISMLOperation {
    private ISMLRepository repository;
    private Object[] arguments;

    public AbstractSMLOperation(ISMLRepository repository) {
        this.repository = repository;
    }

    @Override
    public void setArguments(Object[] arguments) throws IllegalArgumentException {
        this.arguments = arguments;
    }

    @Override
    public void addArgument(Object argument) throws IllegalArgumentException {
        Object[] newArguments = new Object[this.arguments == null ? 1 : this.arguments.length + 1];
        if (this.arguments != null) {
            System.arraycopy(this.arguments, 0, newArguments, 0, this.arguments.length);
        }
        newArguments[newArguments.length - 1] = argument;
        this.arguments = newArguments;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    protected ISMLRepository getRepository() {
        return this.repository;
    }

    protected void setRepository(ISMLRepository repository) {
        this.repository = repository;
    }

    protected boolean checkType(Class<?> expected, Class<?> actual) {
        if (expected == actual) {
            return true;
        }
        Class<?>[] interfaces = actual.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i] == expected) {
                return true;
            }
            ++i;
        }
        Class<?> superClass = actual.getSuperclass();
        if (superClass == null) {
            return false;
        }
        return this.checkType(expected, actual.getSuperclass());
    }

    protected boolean checkType(Object[] arguments, Class<?> expected) {
        int i = 0;
        while (i < arguments.length) {
            if (!this.checkType(expected, arguments[i].getClass())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean checkType(Object[] arguments, Class<?>[] expectedClasses) {
        if (arguments.length < expectedClasses.length) {
            return false;
        }
        int i = 0;
        while (i < expectedClasses.length) {
            boolean status = this.checkType(expectedClasses[i], arguments[i].getClass());
            if (!status) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Object getOutput() {
        return null;
    }
}

