/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.service.impl;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfMessages;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IRelationshipConstraintHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.osgi.util.NLS;

/**
 * An abstract implementation of IRelationshipConstraintHandler.
 * Adopters can extend this class or provide a direct implementation
 * of {@link IRelationshipConstraintHandler}
 * 
 * @provisional
 * @author Ali Mehregani
 */
public abstract class AbstractRelationshipConstraintHandler extends AbstractQueryHandler implements IRelationshipConstraintHandler
{
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.service.IRelationshipConstraintHandler#execute(org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IEdges, org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem, org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem, org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint)
	 */
	public IEdges execute(IEdges context, IConstraint constraint) throws CMDBfServiceException
	{
		if (!isInitialized())
		{
			throw new CMDBfServiceException (
					CMDBfServiceException.RECIEVER, 
					CMDBfServiceException.QUERY_ERROR,
					CMDBfMessages.faultsQueryError,
					CMDBfInternalUtility.createTextNode(NLS.bind(CMDBfMessages.faultsCommonUninitialized, this.getClass().getName())));
		}
		
		return handle(context, constraint);
	}
	
	/**
	 * Handler this constraint
	 * 
	 * @param context The context
	 * @param constraint The constraint
	 * @return The result of handling this constraint
	 */
	protected abstract IEdges handle(IEdges context, IConstraint constraint) throws CMDBfServiceException;
	
}
