/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.input.artifacts;

import java.io.StringWriter;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.IQueryTransformerConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IDepthLimit;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IItemReference;

public class DepthLimit implements IDepthLimit
{
	private IItemReference intermediateItemTemplate;
	private int maxIntermediateItems;
	
	public IItemReference getIntermediateItemTemplate()
	{		
		return intermediateItemTemplate;
	}
	
	
	public void setIntermediateItemTemplate(IItemReference intermediateItemTemplate)
	{
		this.intermediateItemTemplate = intermediateItemTemplate;
	}

	public int getMaxIntermediateItems()
	{		
		return maxIntermediateItems;
	}

	public void setMaxIntermediateItems(int maxIntermediateItems)
	{
		this.maxIntermediateItems = maxIntermediateItems;
	}


	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(ICMDBfServicesConstants.OPEN_ANGLE_BRACKET+ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.DEPTH_LIMIT_ELEMENT);
		writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
		CMDBfServicesUtil.writeAttribute(writer, IQueryTransformerConstants.MAX_INTERMEDIATE_ITEMS_ATTRIBUTE, ""+maxIntermediateItems);
		writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
		CMDBfServicesUtil.writeAttribute(writer, IQueryTransformerConstants.INTERMEDIATE_ITEM_TEMPLATE_ATTRIBUTE, intermediateItemTemplate.getId());
		writer.write(ICMDBfServicesConstants.FORWARD_SLASH+ ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET + ICMDBfServicesConstants.nl);
	}


	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime
				* result
				+ ((intermediateItemTemplate == null) ? 0
						: intermediateItemTemplate.hashCode());
		result = prime * result + maxIntermediateItems;
		return result;
	}


	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final DepthLimit other = (DepthLimit) obj;
		if (intermediateItemTemplate == null) {
			if (other.intermediateItemTemplate != null)
				return false;
		} else if (!intermediateItemTemplate
				.equals(other.intermediateItemTemplate))
			return false;
		if (maxIntermediateItems != other.maxIntermediateItems)
			return false;
		return true;
	}
}
