/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.input.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.IQueryTransformerConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IInstanceIdConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;

/**
 * @author David Whiteman
 */
public class InstanceIdConstraint implements IInstanceIdConstraint {

	private List<IInstanceId> instanceIds = new ArrayList<IInstanceId>();

	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.artifacts.input.IConstraint#getType()
	 */
	public int getType()
	{
		return IConstraint.INSTANCE_ID_CONSTRAINT;
	}

	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.INSTANCE_ID_CONSTRAINT_ELEMENT)+ICMDBfServicesConstants.nl);
		
		CMDBfServicesUtil.outputListToXML(writer, indent+1, instanceIds);
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.INSTANCE_ID_CONSTRAINT_ELEMENT)+ICMDBfServicesConstants.nl);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((instanceIds == null) ? 0 : instanceIds.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final InstanceIdConstraint other = (InstanceIdConstraint) obj;
		if (instanceIds == null) {
			if (other.instanceIds != null)
				return false;
		} else if (!instanceIds.equals(other.instanceIds))
			return false;
		return true;
	}

	public void addInstanceId(IInstanceId instanceId) {
		instanceIds.add(instanceId);
	}

	public IInstanceId[] getInstanceIds() {
		return instanceIds.toArray(new IInstanceId[instanceIds.size()]);
	}
}
