/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.input.artifacts;

import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.IQueryTransformerConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IOperator;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IPropertyValue;

/**
 * @author David Whiteman
 */
public class PropertyValue implements IPropertyValue {
	private URI namespace;
	private String localName;
	private Boolean matchAny;
	private Boolean recordMetadata;
	private List<IOperator> operators = new ArrayList<IOperator>();

	public URI getNamespace() {
		return namespace;
	}

	public void setNamespace(URI namespace) {
		this.namespace = namespace;
	}

	public String getLocalName() {
		return localName;
	}

	public void setLocalName(String localName) {
		this.localName = localName;
	}

	public boolean isMatchAny() {
		if (primIsMatchAny() == null) {
			return false;
		}
		return primIsMatchAny().booleanValue();
	}

	public void setMatchAny(boolean matchAny) {
		this.matchAny = Boolean.valueOf(matchAny);
	}

	private Boolean primIsMatchAny() {
		return matchAny;
	}

	private Boolean primIsRecordMetadata() {
		return recordMetadata;
	}
	
	public boolean isRecordMetadata() {
		if (primIsRecordMetadata() == null) {
			return false;
		}
		return primIsRecordMetadata().booleanValue();
	}

	public void setRecordMetadata(boolean recordMetadata) {
		this.recordMetadata = recordMetadata;
	}

	public IOperator[] getOperators() {
		return operators.toArray(new IOperator[operators.size()]);
	}

	public void addOperator(IOperator operator) {
		operators.add(operator);
	}

	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.artifacts.input.IConstraint#getType()
	 */
	public int getType()
	{
		return IConstraint.PROPERTY_VALUE;
	}

	public String toString() {
		StringWriter writer = new StringWriter();
		toXML(writer, 0);
		return writer.toString();
	}
	
	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(ICMDBfServicesConstants.OPEN_ANGLE_BRACKET+ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.PROPERTY_VALUE_ELEMENT+ICMDBfServicesConstants.SINGLE_SPACE);
		CMDBfServicesUtil.writeAttribute(writer, ICMDBfServicesConstants.NAMESPACE_ATTRIBUTE, getNamespace().toString());
		writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
		CMDBfServicesUtil.writeAttribute(writer, ICMDBfServicesConstants.LOCAL_NAME_ATTRIBUTE, getLocalName());
		if (primIsRecordMetadata() != null) {
			writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
			CMDBfServicesUtil.writeAttribute(writer, IQueryTransformerConstants.RECORD_METADATA_ATTRIBUTE, primIsRecordMetadata().toString());
		}
		if (primIsMatchAny() != null) {
			writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
			CMDBfServicesUtil.writeAttribute(writer, IQueryTransformerConstants.MATCH_ANY_ATTRIBUTE, primIsMatchAny().toString());
		}
		writer.write(ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET + ICMDBfServicesConstants.nl);

		CMDBfServicesUtil.outputListToXML(writer, indent+1, operators);
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.PROPERTY_VALUE_ELEMENT)+ICMDBfServicesConstants.nl);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((localName == null) ? 0 : localName.hashCode());
		result = prime * result
				+ ((matchAny == null) ? 0 : matchAny.hashCode());
		result = prime * result
				+ ((namespace == null) ? 0 : namespace.hashCode());
		result = prime * result
				+ ((operators == null) ? 0 : operators.hashCode());
		result = prime * result
				+ ((recordMetadata == null) ? 0 : recordMetadata.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final PropertyValue other = (PropertyValue) obj;
		if (localName == null) {
			if (other.localName != null)
				return false;
		} else if (!localName.equals(other.localName))
			return false;
		if (matchAny == null) {
			if (other.matchAny != null)
				return false;
		} else if (!matchAny.equals(other.matchAny))
			return false;
		if (namespace == null) {
			if (other.namespace != null)
				return false;
		} else if (!namespace.equals(other.namespace))
			return false;
		if (operators == null) {
			if (other.operators != null)
				return false;
		} else if (!operators.equals(other.operators))
			return false;
		if (recordMetadata == null) {
			if (other.recordMetadata != null)
				return false;
		} else if (!recordMetadata.equals(other.recordMetadata))
			return false;
		return true;
	}
}
