/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.input.artifacts;

import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.IQueryTransformerConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IPropertyId;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.ISelectedRecordType;

public class SelectedRecordType implements ISelectedRecordType {

	private List<IPropertyId> selectedProperties = new ArrayList<IPropertyId>(); // 0 or more
	private String localName;
	private URI namespace;

	public void addSelectedProperty(IPropertyId property) {
		selectedProperties.add(property);
	}

	public IPropertyId[] getSelectedProperties() {
		return selectedProperties.toArray(new IPropertyId[selectedProperties.size()]);
	}

	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(ICMDBfServicesConstants.OPEN_ANGLE_BRACKET+ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.SELECTED_RECORD_TYPE_ELEMENT);
		writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
		CMDBfServicesUtil.writeAttribute(writer, ICMDBfServicesConstants.NAMESPACE_ATTRIBUTE, getNamespace().toString());
		writer.write(ICMDBfServicesConstants.nl);
		CMDBfServicesUtil.addIndent(writer, indent+1);
		CMDBfServicesUtil.writeAttribute(writer, ICMDBfServicesConstants.LOCAL_NAME_ATTRIBUTE, getLocalName());
		writer.write(ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET + ICMDBfServicesConstants.nl);

		CMDBfServicesUtil.outputListToXML(writer, indent+1, selectedProperties);

		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.SELECTED_RECORD_TYPE_ELEMENT)+ICMDBfServicesConstants.nl);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IPropertyId#getLocalName()
	 */
	public String getLocalName() {
		return localName;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IPropertyId#getNamespace()
	 */
	public URI getNamespace() {
		return namespace;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IPropertyId#setLocalName(java.lang.String)
	 */
	public void setLocalName(String localName) {
		this.localName = localName;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IPropertyId#setNamespace(java.net.URI)
	 */
	public void setNamespace(URI namespace) {
		this.namespace = namespace;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((localName == null) ? 0 : localName.hashCode());
		result = prime * result
				+ ((namespace == null) ? 0 : namespace.hashCode());
		result = prime
				* result
				+ ((selectedProperties == null) ? 0 : selectedProperties
						.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final SelectedRecordType other = (SelectedRecordType) obj;
		if (localName == null) {
			if (other.localName != null)
				return false;
		} else if (!localName.equals(other.localName))
			return false;
		if (namespace == null) {
			if (other.namespace != null)
				return false;
		} else if (!namespace.equals(other.namespace))
			return false;
		if (selectedProperties == null) {
			if (other.selectedProperties != null)
				return false;
		} else if (!selectedProperties.equals(other.selectedProperties))
			return false;
		return true;
	}

}
