/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.response.artifacts;

import java.io.StringWriter;
import java.util.List;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.IQueryTransformerConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryServiceElementCollection;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IRelationshipConvertible;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;

/**
 * This is an aggregate of Relationship instances that share
 * a common role, specified by the templateId
 * 
 * @author David Whiteman
 * @author Ali Mehregani
 */
public class Edges extends GraphElementCollection implements IEdges 
{
	public Edges(String templateId) 
	{
		super(templateId);
	}
	
	public Edges (IRelationshipTemplate relationshipTemplate)
	{
		super(relationshipTemplate);
	}
	
	public Edges(IRelationshipTemplate relationshipTemplate, IRelationshipConvertible relationshipConvertible) 
	{
		super(relationshipTemplate);
		addRelationship(relationshipConvertible);
	}
	
	@SuppressWarnings("unchecked")
	public Edges(IRelationshipTemplate relationshipTemplate, List relationships) 
	{
		super(relationshipTemplate, relationships);
	}

	public void addRelationship(IRelationshipConvertible relationship) 
	{
		getCollection().add(relationship.toRelationship(this));
	}

	public void addRelationship(IRelationship relationship) 
	{
		getCollection().add(relationship);
	}
	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(ICMDBfServicesConstants.OPEN_ANGLE_BRACKET+ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.EDGES_ELEMENT+" "+IQueryTransformerConstants.TEMPLATE_ID_ATTRIBUTE+"=\""+getId()+ICMDBfServicesConstants.DOUBLE_QUOTE+ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);
		
		CMDBfServicesUtil.outputListToXML(writer, indent+1, getCollection());
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.EDGES_ELEMENT)+ICMDBfServicesConstants.nl);
	}

	public int getType()
	{
		return IQueryServiceElementCollection.RELATIONSHIPS;
	}
	
	public IRelationshipTemplate getRelationshipTemplate()
	{
		return (IRelationshipTemplate)getTemplate();
	}

}
