/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.response.artifacts;

import java.io.StringWriter;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.GraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.InstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElementCollection;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;

/**
 * @author David Whiteman
 */
public class Relationship extends GraphElement implements IRelationship
{
	private IInstanceId sourceId;
	private IInstanceId targetId;

	public IInstanceId getSourceId() {
		return sourceId;
	}

	public void setSourceId(IInstanceId sourceItem) {
		this.sourceId = sourceItem;
	}

	public IInstanceId getTargetId() {
		return targetId;
	}

	public void setTargetId(IInstanceId targetItem) {
		this.targetId = targetItem;
	}

	protected String getElementName() {
		return ICMDBfServicesConstants.RELATIONSHIP_ELEMENT;
	}

	protected void outputAdditionalSubelements(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.SOURCE_ELEMENT)+ICMDBfServicesConstants.nl);
		((InstanceId)getSourceId()).outputIdentifiers(writer, indent+1);
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.SOURCE_ELEMENT)+ICMDBfServicesConstants.nl);

		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.TARGET_ELEMENT)+ICMDBfServicesConstants.nl);
		((InstanceId)getTargetId()).outputIdentifiers(writer, indent+1);
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.TARGET_ELEMENT)+ICMDBfServicesConstants.nl);
	}

	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result
				+ ((sourceId == null) ? 0 : sourceId.hashCode());
		result = prime * result
				+ ((targetId == null) ? 0 : targetId.hashCode());
		return result;
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		final Relationship other = (Relationship) obj;
		if (sourceId == null) {
			if (other.sourceId != null)
				return false;
		} else if (!sourceId.equals(other.sourceId))
			return false;
		if (targetId == null) {
			if (other.targetId != null)
				return false;
		} else if (!targetId.equals(other.targetId))
			return false;
		return true;
	}

	/** 
	 * @see org.eclipse.cosmos.dc.cmdbf.artifacts.response.IRelationshipConvertible#toRelationship()
	 */
	public IRelationship toRelationship(IGraphElementCollection parent)
	{
		return this;
	}
}
