/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;

/**
 * Represents a depth limit associate with a relationship template
 * 
 * @provisional
 * @author Ali Mehregani
 */
public interface IDepthLimit extends IXMLWritable {
	/**
	 * Returns the maximum intermediate items for this depth limit. The value
	 * returned must be >= 0. Even though returning 0 is valid, the existence of
	 * depth limit is only useful when the value returned is >= 1.
	 * 
	 * @return The maximum intermediate items for this depth limit
	 */
	public int getMaxIntermediateItems();

	/**
	 * Sets the maximum intermediate items for this depth limit.
	 * 
	 * @param maxIntermediateItems
	 *            The maximum intermediate items. The argument must be >= 0.
	 *            Even though 0 is valid, the existence of a depth limit is only
	 *            useful when the maximum intermediate items is >= 1.
	 */
	public void setMaxIntermediateItems(int maxIntermediateItems);

	/**
	 * Returns an item reference corresponding to the valid intermediate items.
	 * 
	 * @return An item reference corresponding to the intermediate items.
	 */
	public IItemReference getIntermediateItemTemplate();

	/**
	 * Sets an item reference corresponding to the valid intermediate items.
	 * 
	 * @param intermediateItemTemplate
	 *            An item reference corresponding to the valid intermediate
	 *            items
	 */
	public void setIntermediateItemTemplate(IItemReference intermediateItemTemplate);
}
