/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;

/**
 * Represents of the operator elements in the query structure, including <isNull>, <equals>,
 * <lessThan>, <greaterThan>, <greaterThanOrEqual>, <lessThanOrEqual>, <contains>, and <like>.
 * 
 * Example:
 *  <equals negate=true>3</equals>
 *  
 * is equivalent to:
 *  
 * 	IOperator equals = QueryInputArtifactFactory.getInstance().createOperator(IOperator.EQUALS);
 *  equals.setValue(3);
 *  equals.setNegate(true);
 * 
 * @provisional
 * @author David Whiteman
 */
public interface IOperator extends IXMLWritable {
	/* operator types */
	public static final int EQUALS = 0;
	public static final int GREATER_THAN = 1;
	public static final int LESS_THAN = 2;
	public static final int GREATER_THAN_OR_EQUAL = 3;
	public static final int LESS_THAN_OR_EQUAL = 4;
	public static final int LIKE = 5;
	public static final int CONTAINS = 6;
	public static final int IS_NULL = 7;

	/**
	 * Answer whether negate=true, i.e. whether the negation of the operator result should
	 * be considered.  Default is false.
	 * 
	 * @return
	 */
	public boolean isNegated();	
	
	/**
	 * Set whether the operator result should be negated
	 * 
	 * @param negate
	 */
	public void setNegate(boolean negate);

	/**
	 * Answer the type of the operator, one of EQUALS, GREATER_THAN, LESS_THAN, GREATER_THAN_OR_EQUAL,
	 * LESS_THAN_OR_EQUAL, LIKE, CONTAINS, IS_NULL.  This type should be non-modifiable, set on object
	 * creation.
	 * 
	 * @return
	 */
	public int getType();

	/**
	 * Answer whether text-oriented comparison operators should be case sensitive.
	 * 
	 * @return
	 */
	public boolean isCaseSensitive();
	
	/**
	 * Set whether text-oriented comparison operators should be case-sensitive.
	 * 
	 * @param caseSensitive
	 */
	public void setCaseSensitive(boolean caseSensitive);

	/**
	 * Answer the value being compared using the operator.
	 * 
	 * @return
	 */
	public Object getValue();

	/**
	 * Set the value being compared using the operator.
	 * 
	 * @param value
	 */
	public void setValue(Object value);
}
